// libpngrecolor.h - part of pngrecolor
// Copyright (C) 2010 by Jason Summers (from original libpngrewrite.h)
// Modifications (C) 2013-2021 by Brian Lindholm

#ifndef LIBPNGRECOLOR_H_INCLUDED
#define LIBPNGRECOLOR_H_INCLUDED

#ifdef __cplusplus
extern "C" {
#endif

#if defined(_WIN32) && !defined(__GNUC__) && !defined(PNGRW_WINDOWS)
# define PNGRW_WINDOWS
#endif

#ifdef HAVE_STDIO_H
# include <stdio.h>
#endif

#ifdef PNGRW_WINDOWS
# include <tchar.h>
# define PNGRW_CHAR TCHAR
#else
# define PNGRW_CHAR char
#endif

struct pngrw_ctx;
struct pngrw_ctx *pngrw_create(void);
void pngrw_destroy(struct pngrw_ctx *ctx);

int pngrw_read_filename(struct pngrw_ctx *ctx, const PNGRW_CHAR *in_filename, int verbose);
int pngrw_write_filename(struct pngrw_ctx *ctx, const PNGRW_CHAR *out_filename, int no_interlace);

int pngrw_read_stdio(struct pngrw_ctx *ctx, FILE *infp, int verbose);
int pngrw_write_stdio(struct pngrw_ctx *ctx, FILE *outfp, int no_interlace);

typedef void (*pngrw_print_fn_type)(struct pngrw_ctx *ctx, const PNGRW_CHAR *s);

void pngrw_set_print_fn(struct pngrw_ctx *ctx, pngrw_print_fn_type prntfn);
void pngrw_set_error_fn(struct pngrw_ctx *ctx, pngrw_print_fn_type errfn);

void pngrw_set_userdata(struct pngrw_ctx *ctx, void *u);
void *pngrw_get_userdata(struct pngrw_ctx *ctx);
void pngrw_set_sort_by_frequency(struct pngrw_ctx *ctx, int n);

int pngrw_optimize_image(struct pngrw_ctx *ctx, int verbose);

const PNGRW_CHAR *pngrw_get_version_string(void);

#ifdef __cplusplus
}
#endif

#endif // LIBPNGRECOLOR_H_INCLUDED
