/*
//
// Copyright (C) 2006-2025 Jean-Franois DEL NERO
//
// This file is part of the HxCFloppyEmulator library
//
// HxCFloppyEmulator may be used and distributed without restriction provided
// that this copyright statement is not removed from the file and that any
// derivative work contains the original copyright notice and the associated
// disclaimer.
//
// HxCFloppyEmulator is free software; you can redistribute it
// and/or modify  it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// HxCFloppyEmulator is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with HxCFloppyEmulator; if not, write to the Free Software
// Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
//
*/
typedef struct pcimgfileformats_t_
{
	unsigned int filesize;
	int numberoftrack;
	int sectorpertrack;
	int numberofside;
	int gap3len;
	int interleave;
	int RPM;
	int bitrate;
	int encoding;
	int interface_mode;
}pcimgfileformats_t;

static pcimgfileformats_t pcimgfileformats[]=
{
	{163840,40,8,1,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{184320,40,9,1,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{327680,40,8,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{368640,40,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},

	{614400,80,15,1,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{655360,80,8,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{663552,81,8,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{709632,77,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{718848,78,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{728064,79,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{737280,80,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{746496,81,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{755712,82,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{764928,83,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{774144,84,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{783360,85,9,2,84,1,300,250000,1,IBMPC_DD_FLOPPYMODE},

	{788480,77,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{798720,78,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{808960,79,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{819200,80,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{829440,81,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{839680,82,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{839680,82,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{844800,82,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{849920,83,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{855040,83,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{860160,84,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{870400,85,10,2,30,1,300,250000,1,IBMPC_DD_FLOPPYMODE},

	{867328,77,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{878592,78,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{889856,79,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{901120,80,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{912384,81,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{923648,82,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{934912,83,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{946176,84,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},
	{957440,85,11,2,3,2,300,250000,1,IBMPC_DD_FLOPPYMODE},

	{1182720,77,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1198080,78,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1213440,79,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1228800,80,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1244160,81,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1259520,82,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},
	{1274880,83,15,2,84,1,360,500000,1,IBMPC_HD_FLOPPYMODE},

	{1419264,77,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1437696,78,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1456128,79,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1474560,80,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1492992,81,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1511424,82,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1529856,83,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1548288,84,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1566720,85,18,2,84,1,300,500000,1,IBMPC_HD_FLOPPYMODE},

	{1655808,77,21,2,18,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1677312,78,21,2,18,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1698816,79,21,2,18,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1720320,80,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1741824,81,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1763328,82,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1784832,83,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1806336,84,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},
	{1827840,85,21,2,15,1,300,500000,1,IBMPC_HD_FLOPPYMODE},

	{2949120,80,36,2,84,1,300,1000000,1,IBMPC_ED_FLOPPYMODE},
	{0,0,0,0,0,0}
};
