; master library - PC98
;
; Description:
;	RS-232CCȕ^IA荞ݏ
;
; Function/Procedures:
;	void sio_start( int port, int speed, int param, int flow ) ;
;	void sio_end(int port) ;
;	void sio_leave(int port) ;
;	void sio_setspeed( int port, int speed ) ;
;	void sio_enable( int port, ) ;
;	void sio_disable( int port ) ;
;
; Parameters:
;	speed	{[[gB0=ݒ, SIO_150`SIO_38400=ݒ
;	param	ʐMp[^BSIO_N81Ȃ
;	flow	t[̕@B0 = none, 1 = RS/CS, 2 = XON/XOFF
;
; Returns:
;	none
;
; Binding Target:
;	Microsoft-C / Turbo-C / Turbo Pascal
;
; Running Target:
;	PC-9801
;
; Requiring Resources:
;	CPU: 8086
;
; Notes:
;	sio_startsAAvP[VIOsio_endKĂԂƁB
;	sio_startAsio_endsOɍĎsƁAp[^ނ̕ύX
;	ŝ݂ƂȂB
;	sio_end̑sio_leavegƊeMOFFsȂB
;
; Compiler/Assembler:
;	TASM 3.0
;	OPTASM 1.6
;
; Author:
;	ˏF
;
; Revision History:
;	92/12/07 Initial
;	93/ 1/31 sio_leaveǉB75bpsp~B
;	93/ 2/12 sio_check_csp~(ĂȂ,荞݂ς)
;	93/ 2/17 荞݃}XN̑ޔ/
;	93/ 2/19 sio_start, modeȂ[h
;	93/ 7/19 荞݋(STI)rpushf->cli->popfɂB
;	93/ 7/23 [M0.20] portǉBg͂܂ȂB
;	93/ 9/11 [M0.21] xɂ SIO_MIDI (SIO_MIDISPEED, 31250bps)ǉB
;	93/ 9/11 [M0.21] nC]ɑΉBmF
;			_Bǂ͂ǂ?
;	93/10/28 [M0.21] sio_bit_offbugfixA܂܂
;			̂ȂȂĂ(^^; ̂ŏC
;	95/5/29  [M0.23] 8MHznł͂20800bpsɂ
;			(SIO_19200w肷20800bpsɂȂ)
;
	.MODEL SMALL
	include func.inc
	include sio.inc

	.DATA?
old_intvect	dd	?
old_intmask	db	?
old_intmask_pic	db	?

	.CODE
	EXTRN DOS_SETVECT:CALLMODEL
	EXTRN SIO_BIT_OFF:CALLMODEL


SIO_INT proc far	; {
	push	AX
	in	AL,SYSTEM_PORTC
	push	BX
	push	DS

	push	AX
	and	AL,not SIO_INTMASKS
	out	SYSTEM_PORTC,AL		; ʐM荞݋֎~

	mov	AX,seg DGROUP
	mov	DS,AX

	in	AL,SIO_STAT
	test	AL,SIO_STAT_RXRDY
	jz	short SI_SENDF

	; M荞 -----------------------------

	in	AL,SIO_DATA		; AL = read data

	cmp	sio_flow_type,SIO_FLOW_SOFT
	jne	short SIREC
	; \tgEFAt[̂Ƃ́AXOFF/OFF̎Mɂāc
	cmp	AL,XOFF
	je	short REC_STOP

	cmp	sio_send_stop,1		; ~߂ĂȂȂAʂ̎M
	jne	short SIREC
		; 
	cmp	AL,XON			; XOFF󂯂Ď~܂ĂƂ
	jne	short SI_SEND		; XONȊO̎M͖

	pop	AX
	or	AL,SIO_TXRE_BIT		; M荞݋
	push	AX
	dec	sio_send_stop		; M
	jmp	short SI_SEND
	EVEN

REC_STOP:	; ~܂
	pop	AX
	and	AL,not SIO_TXRE_BIT	; M荞݋֎~
	push	AX
	mov	sio_send_stop,1		; Ɏ~߂ꂽ
	jmp	short SI_SEND
	EVEN

SIREC:	; Mobt@i[Ǒ
	mov	BX,sio_ReceiveLen
	cmp	BX,FLOW_STOP_SIZE	; t[Jn?
	jb	short REC_STORE		; ȂȂ疳Ɋi[

	; ~vo
	cmp	sio_flow_type,1		; SIO_FLOW_SOFT:2
	je	short REC_HARD		; SIO_FLOW_HARD:1
	jb	short REC_CHECKFULL	; SIO_FLOW_NO:0
		; \tgt[
		mov	sio_rec_stop,XOFF		; ~v
		jmp	short REC_CHECKFULL
		EVEN
REC_HARD:
		; n[ht[
		push	AX
		xor	AX,AX
		push	AX
		mov	AL,SIO_CMD_RS
		push	AX
		call	SIO_BIT_OFF
		pop	AX
		mov	sio_rec_stop,1 ; ɑM~vflag

REC_CHECKFULL:
	cmp	BX,RECEIVEBUF_SIZE
	je	short SI_SEND		; tȂ疳

REC_STORE:
	mov	BX,sio_receive_wp
	mov	[BX+sio_receive_buf],AL	; i[
	RING_INC BX,RECEIVEBUF_SIZE,AX	; (M)݃|C^XV
	mov	sio_receive_wp,BX
	inc	sio_ReceiveLen

		; ł܂Xe[^Xǂł̂́A܂ł̊Ԃ
		; M\ɕςƂɂ悭΁cƂ킯
SI_SEND:
	in	AL,SIO_STAT
SI_SENDF:
	test	AL,SIO_STAT_TXRDY	; M?
	jz	short SI_EXIT

	; M荞 ----------------------
	cmp	sio_flow_type,SIO_FLOW_SOFT
	jne	short SI_SEND_1

	; \tgt[
SI_SEND_SOFT:
	mov	AX,sio_rec_stop
	cmp	AX,1
	jle	short SI_SEND_1
	; 荞݂Ȃ狭M
SI_XSEND:
	out	SIO_DATA,AL		; XON/XOFFM
	mov	sio_rec_stop,1
	cmp	AL,XOFF			; XOFFȂM~tO𗧂ĂāA
	je	short SI_EXIT
	mov	sio_rec_stop,0		; XONȂΎMȂ̂
	jmp	short SI_EXIT
	EVEN

	; Mobt@ɂȂƂ
SI_EMPTY:
	mov	sio_send_stop,2		; obt@
SI_STOP:
	mov	AL,20h			; EOI
	out	0,AL
	pop	AX
	and	AL,not SIO_TXRE_BIT	; M荞݋֎~
	out	SYSTEM_PORTC,AL		; M荞݃tOݒ

	pop	DS
	pop	BX
	pop	AX
	iret

	EVEN
SI_SEND_1:
	xor	AX,AX
	cmp	sio_send_stop,AX
	jnz	short SI_STOP		; ~Ȃ瑗Ȃ
	cmp	sio_SendLen,AX
	je	short SI_EMPTY		; obt@Ȃ炨肾
	mov	BX,sio_send_rp		; Mobt@Ă
	mov	AL,[BX+sio_send_buf]	; obt@ALɎ
	out	SIO_DATA,AL		; MႤ
	RING_INC BX,SENDBUF_SIZE,AX	; |C^XV
	mov	sio_send_rp,BX
	dec	sio_SendLen
	je	short SI_EMPTY
	pop	AX
	or	AX,SIO_TXRE_BIT		; M
	push	AX
SI_EXIT:
	mov	AL,20h			; EOI
	out	0,AL
	pop	AX
	out	SYSTEM_PORTC,AL		; M荞݃tOݒ

	pop	DS
	pop	BX
	pop	AX
	iret
SIO_INT endp		; }

func SIO_START		; sio_start() {
	push	BP
	mov	BP,SP
	pushf

	; 
	port	= (RETSIZE+4)*2
	speed	= (RETSIZE+3)*2
	param	= (RETSIZE+2)*2
	flow	= (RETSIZE+1)*2

	in	AL,SYSTEM_PORTC		; VXe|[gǂ
	and	AL,SIO_INTMASKS
	mov	CX,AX			; CL = ̊荞݃}XN

	push	[BP+port]
	call	CALLMODEL PTR SIO_DISABLE

	; [NGANA
	xor	AX,AX
	mov	sio_send_rp,AX
	mov	sio_send_wp,AX
	mov	sio_SendLen,AX
	mov	sio_receive_rp,AX
	mov	sio_receive_wp,AX
	mov	sio_ReceiveLen,AX
	mov	sio_send_stop,2
	mov	sio_rec_stop,AX

	cmp	byte ptr sio_cmdbackup,AL
	je	short START_FIRST
	; Qxڈȍ~

	; x̐ݒ
	push	[BP+port]
	push	[BP+speed]
	call	CALLMODEL PTR SIO_SETSPEED
	jmp	short START_RESET
	EVEN

START_FIRST:
	; 荞݃xN^̓o^
	mov	old_intmask,CL		; 荞݃}XN̑ޔ
	in	AL,02h
	or	AL,not 00010000b	; 8251Å荞݃}XNۑ
	mov	old_intmask_pic,AL

	mov	AX,SIO_INTVECT
	push	AX
	push	CS
	mov	AX,offset SIO_INT
	push	AX
	call	DOS_SETVECT
	mov	word ptr old_intvect,AX
	mov	word ptr old_intvect+2,DX

	; x̐ݒ
	push	[BP+port]
	push	[BP+speed]
	call	CALLMODEL PTR SIO_SETSPEED

	; t[@̐ݒ
	mov	AX,[BP+flow]
	mov	sio_flow_type,AX

	mov	AL,[BP+param]
	and	AL,11111100b		; [h[h
	jz	short SKIP_MODE
	mov	BL,AL

	; 8251Zbg
	; 菇
	CLI
	xor	AX,AX
	out	SIO_CMD,AL
	jmp	$+2
	out	SIO_CMD,AL
	jmp	$+2
	out	SIO_CMD,AL
	jmp	$+2
START_RESET:
	CLI
	mov	AL,40h			; RESET
	out	SIO_CMD,AL
	jmp	$+2

	; [h
	mov	AL,BL
	or	AL,2			; x16
	out	SIO_MODE,AL
	jmp	$+2

SKIP_MODE:
	; R}h
	mov	AL,00110111b		; ? RESET RS ERRCLR  SBRK RXEN ER TXEN
	out	SIO_CMD,AL
	mov	byte ptr sio_cmdbackup,AL

	in	AL,02h
	and	AL,not 00010000b	; 8251Å荞݂
	out	02h,AL

	popf
	push	[BP+port]
	call	CALLMODEL PTR SIO_ENABLE
	pop	BP
	ret	8
endfunc			; }

func SIO_END		; sio_end() {
	push	BP
	mov	BP,SP
	port = (RETSIZE+1)*2

	cmp	byte ptr sio_cmdbackup,0
	jne	short END_GO
	pop	BP
	ret	2
END_GO:
	push	[BP+port]
	call	CALLMODEL PTR SIO_DISABLE
	; e OFF
	xor	AX,AX
	push	AX
	mov	AX,SIO_CMD_ER or SIO_CMD_RS or SIO_CMD_BREAK
	push	AX
	call	SIO_BIT_OFF
	jmp	short LEAVE_GO
endfunc			; }

func SIO_LEAVE		; sio_leave() {
	push	BP
	mov	BP,SP
	port = (RETSIZE+1)*2

	cmp	byte ptr sio_cmdbackup,0
	je	short LEAVE_IGNORE
	push	[BP+port]
	call	CALLMODEL PTR SIO_DISABLE
LEAVE_GO:
	pushf
	CLI
	in	AL,02h
	or	AL,00010000b		; 8251Å荞݂}XN
	out	02h,AL
	popf

	; 荞݃xN^̕
	mov	AX,SIO_INTVECT
	push	AX
	push	word ptr old_intvect+2
	push	word ptr old_intvect
	call	DOS_SETVECT
	mov	sio_cmdbackup,0

	; 荞݃}XN̕
	pushf
	CLI

	in	AL,SYSTEM_PORTC
	jmp	short $+2
	or	AL,old_intmask
	out	SYSTEM_PORTC,AL

	in	AL,02h
	and	AL,old_intmask		; 8251Å荞݃}XN𕜌
	out	02h,AL

	popf

LEAVE_IGNORE:
	pop	BP
	ret	2
endfunc			; }

func SIO_SETSPEED	; sio_setspeed() {
	mov	BX,SP
	; 
	port	= (RETSIZE+1)*2
	speed	= RETSIZE*2
	mov	AX,SS:[BX+speed]
	test	AX,AX
	jz	short SPEED_IGNORE

	mov	CX,AX

	xor	BX,BX
	mov	ES,BX
	test	byte ptr ES:[0501H],80h
	jz	short SPEED_5MHz	; 5MHzn? 8MHzn?
	; 8MHzn(^C}2MHz)
	mov	AX,8		; 8(20800bps)ɂ
	mov	BX,1664
	mov	DX,4		; RS-MIDI 31250bpsߎlp
	jmp	short SPEED_1
SPEED_5MHz:
	; 5MHzn(^C}2.5MHz)
	mov	AX,9		; 9(38400bps)ɂ
	mov	BX,2048
	mov	DX,5		; RS-MIDI 31250bpsߎlp
SPEED_1:
	cmp	CX,SIO_MIDISPEED
	je	short MIDI
	sub	CX,AX		; CX = min(CX,AX)
	sbb	DX,DX
	and	CX,DX
	add	CX,AX
	shr	BX,CL		; BX = ^C}#2̕l
	mov	DX,BX
MIDI:

	pushf
	CLI
	mov	AL,0b6h		; JE^#2[hR
	out	77h,AL
	jmp	$+2
	jmp	$+2
	mov	AL,DL
	out	75h,AL		; 
	jmp	$+2
	jmp	$+2
	mov	AL,DH
	out	75h,AL		; 
	popf
SPEED_IGNORE:
	ret 4
endfunc			; }

func SIO_ENABLE		; sio_enable() {
	pushf
	CLI
	in	AL,SYSTEM_PORTC
	jmp	$+2
	and	AL,not SIO_INTMASKS
	or	AL,SIO_TXRE_BIT or SIO_RXRE_BIT
	out	SYSTEM_PORTC,AL
	popf
	ret	2
endfunc			; }

func SIO_DISABLE	; sio_disable() {
	pushf
	CLI
	in	al,SYSTEM_PORTC		; VXe|[gǂ
	jmp	$+2
	and	al,not SIO_INTMASKS
	out	SYSTEM_PORTC,al		; RS-232C̑S荞݂֎~
	popf
	ret	2
endfunc			; }

END
