#pragma once

namespace arkostracker
{

enum CommandIds: uint16_t            // Not an enum class, because this must be compatible with JUCE's commands, else a cast is needed.
{
    newSong = 0x3000U,
    loadSong,
    saveSong,
    saveSongAs,
    clearRecentFiles,

    playSongFromStart,
    playSongContinue,
    playPatternFromStart,
    playPatternFromCursorOrBlock,
    togglePlayPatternFromBlockIfPresentElsePlayPattern,
    stop,

    increaseOctave,
    decreaseOctave,

    previousInstrument,
    nextInstrument,

    setupGeneral,
    setupKeyboardMapping,
    setupThemeEditor,
    setupPatternViewer,
    setupAudioInterface,
    setupOutput,
    setupSourceProfile,
    setupSerial,

    editSongProperties,

    exportToAkg,
    exportToAky,
    exportToAkm,
    exportToFap,
    exportToYm,
    exportToVgm,
    exportToWav,
    exportSfxs,
    exportEvents,
    exportToRaw,
    exportSamples,

    openStreamedMusicAnalyzer,
    openInstrumentOptimizer,
    rearrangePatterns,
    rearrangeAndDeleteUnusedPatterns,
    clearPatterns,

    openAboutPage,

    restoreLayout0,
    restoreLayout1,
    restoreLayout2,
    restoreLayout3,

    openLinker,
    openPatternViewer,
    openInstrumentEditor,
    openInstrumentList,
    openArpeggioTable,
    openArpeggioList,
    openPitchTable,
    openPitchList,
    openTestArea,

    listRenameItem,
    listAddItem,
    listDuplicateItems,
    listInsertItemAfter,
    listLoadItem,
    listSaveItem,

    linkerGotoNext,
    linkerGotoPrevious,
    linkerGotoNextPage,
    linkerGotoPreviousPage,
    linkerGotoStart,
    linkerGotoEnd,

    linkerGrowNext,
    linkerGrowPrevious,
    linkerGrowNextPage,
    linkerGrowPreviousPage,
    linkerGrowStart,
    linkerGrowEnd,

    linkerSelectPosition,
    linkerEditPositions,
    linkerDeleteSelectedPositions,
    linkerDuplicateSelectedPositions,
    linkerCloneSelectedPositions,
    linkerCreateNew,

    linkerMarkAsLoopStartAndEnd,
    linkerMarkLoopStart,
    linkerMarkEnd,

    linkerIncreasePatternIndex,
    linkerDecreasePatternIndex,

    keyboardCOctavePlus0,
    keyboardCsOctavePlus0,
    keyboardDOctavePlus0,
    keyboardDsOctavePlus0,
    keyboardEOctavePlus0,
    keyboardFOctavePlus0,
    keyboardFsOctavePlus0,
    keyboardGOctavePlus0,
    keyboardGsOctavePlus0,
    keyboardAOctavePlus0,
    keyboardAsOctavePlus0,
    keyboardBOctavePlus0,

    keyboardCOctavePlus1,
    keyboardCsOctavePlus1,
    keyboardDOctavePlus1,
    keyboardDsOctavePlus1,
    keyboardEOctavePlus1,
    keyboardFOctavePlus1,
    keyboardFsOctavePlus1,
    keyboardGOctavePlus1,
    keyboardGsOctavePlus1,
    keyboardAOctavePlus1,
    keyboardAsOctavePlus1,
    keyboardBOctavePlus1,

    keyboardCOctavePlus2,
    keyboardCsOctavePlus2,
    keyboardDOctavePlus2,
    keyboardDsOctavePlus2,
    keyboardEOctavePlus2,

    patternViewerMoveDown,
    patternViewerMoveUp,
    patternViewerMoveFastDown,
    patternViewerMoveFastUp,
    patternViewerMoveTop,
    patternViewerMoveBottom,
    patternViewerMoveLeft,
    patternViewerMoveRight,
    patternViewerMoveToNextChannel,
    patternViewerMoveToPreviousChannel,
    patternViewerMoveToNextPosition,
    patternViewerMoveToPreviousPosition,

    patternViewerMoveDownEnlargeSelection,
    patternViewerMoveUpEnlargeSelection,
    patternViewerMoveFastDownEnlargeSelection,
    patternViewerMoveFastUpEnlargeSelection,
    patternViewerMoveTopEnlargeSelection,
    patternViewerMoveBottomEnlargeSelection,
    patternViewerMoveLeftEnlargeSelection,
    patternViewerMoveRightEnlargeSelection,

    patternViewerToggleRecord,
    patternViewerToggleFollow,
    patternViewerDelete,
    patternViewerDeleteWholeCell,
    patternViewerToggleOverwriteDefaultEffect,
    patternViewerNextDefaultEffect,
    patternViewerPreviousDefaultEffect,

    patternViewerPlayLine,
    patternViewerSetBlockTogglePlayPatternFromBlock,
    patternViewerPlayPatternFromStartIgnoreBlock,

    patternViewerPasteMix,
    patternViewerClearSelection,
    patternViewerTransposePlusOne,
    patternViewerTransposeMinusOne,
    patternViewerTransposePlusOneOctave,
    patternViewerTransposeMinusOneOctave,
    patternViewerInsert,
    patternViewerRemove,
    patternViewerIncreaseEditStep,
    patternViewerDecreaseEditStep,
    patternViewerToggleReadOnly,
    patternViewerGenerateArpeggio,
    patternViewerGenerateInstrument,
    patternViewerNameTrack,
    patternViewerLinkTrack,

    patternViewerSelectTrack,
    patternViewerSelectAllTracks,
    patternViewerCapture,

    patternViewerRst,

    patternViewerToggleSolo,
    patternViewerToggleMute,

    barEditorInsert,
    barEditorDelete,
    barEditorIncreaseValue,
    barEditorIncreaseValueFast,
    barEditorIncreaseValueFastest,
    barEditorDecreaseValue,
    barEditorDecreaseValueFast,
    barEditorDecreaseValueFastest,
    barEditorCursorEdit,
    barEditorCursorRight,
    barEditorCursorRightFast,
    barEditorCursorRightLimit,
    barEditorCursorLeft,
    barEditorCursorLeftFast,
    barEditorCursorLeftLimit,
    barEditorCursorDown,
    barEditorCursorDownFast,
    barEditorCursorDownLimit,
    barEditorCursorUp,
    barEditorCursorUpFast,
    barEditorCursorUpLimit,
    barEditorCursorDuplicateColumn,
    barEditorCursorDuplicateValue,
    barEditorResetValue,

    barEditorCursorSetMainLoopStart,
    barEditorCursorSetMainLoopEnd,
    barEditorToggleMainLoop,
    barEditorIncreaseSpeed,
    barEditorDecreaseSpeed,
    barEditorCursorSetAutoSpreadLoopStart,
    barEditorCursorSetAutoSpreadLoopEnd,
    barEditorToggleAutoSpreadLoop,
    barEditorHideUnusedRows,
    barEditorHideUnusedRowsFull,
    barEditorEnlargeCurrentRow,
    barEditorShrinkCurrentRow,
    barEditorToggleHideInRowAboveCursor,
    barEditorToggleHideInRowBelowCursor,

    psgBarEditorToggleRetrig,
    psgBarEditorGenerateIncreasingVolume,
    psgBarEditorGenerateDecreasingVolume,
};

}   // namespace arkostracker
