#pragma once

#include "../../../export/fap/FapExporter.h"
#include "../../components/dialogs/ModalDialog.h"
#include "../../utils/backgroundTask/BackgroundTaskWithProgress.h"
#include "../common/SubsongChooser.h"

namespace arkostracker 
{

class MainController;
class SongController;

/** Dialog to export to FAP. */
class ExportFapDialog final : public ModalDialog,
                              public BackgroundTaskListener<std::unique_ptr<FapResult>>
{
public:
    /**
     * Constructor.
     * @param mainController the Main Controller.
     * @param listener the listener to close this Dialog.
     */
    ExportFapDialog(MainController& mainController, std::function<void()> listener) noexcept;

    // BackgroundTaskListener method implementations.
    // ======================================================
    void onBackgroundTaskFinished(TaskOutputState taskOutputState, std::unique_ptr<FapResult> result) noexcept override;

private:
    /** Called when the Export button is clicked. */
    void onExportButtonClicked() noexcept;
    /** Called when the Cancel button is clicked. */
    void onCancelButtonClicked() const noexcept;

    /**
     * The user exited a Dialog.
     * @param exit true to exit this page.
     */
    void onDialogExit(bool exit = false) noexcept;

    SongController& songController;

    std::function<void()> listener;

    SubsongChooser subsongChooser;
    juce::Label versionLabel;

    std::unique_ptr<BackgroundTaskWithProgress<std::unique_ptr<FapResult>>> backgroundTask;

    juce::File fileToSaveTo;
    std::unique_ptr<ModalDialog> dialog;
};

}   // namespace arkostracker
