#pragma once

#include <juce_core/juce_core.h>

#include "../../song/Song.h"
#include "../../utils/task/Task.h"

namespace arkostracker
{

class FapResult
{
public:
    FapResult(const juce::MemoryBlock& pFapData, const int pBufferSize, const int pPlayTimeInNops, const int pRegisterCountToPlay, const bool pIsR12Constant) :
            fapData(pFapData),
            bufferSize(pBufferSize),
            playTimeInNops(pPlayTimeInNops),
            registerCountToPlay(pRegisterCountToPlay),
            isR12Constant(pIsR12Constant)
    {
    }

    const juce::MemoryBlock fapData;
    const int bufferSize;
    const int playTimeInNops;
    const int registerCountToPlay;
    const bool isR12Constant;
};

/** Encoder to the FAP format, as a binary file. */
class FapExporter final : public Task<std::unique_ptr<FapResult>>
{
public:
    /**
     * Constructor.
     * @param song the Song.
     * @param subsongId the ID of the Subsong to export.
     */
    FapExporter(const std::shared_ptr<Song>& song, const Id& subsongId) noexcept;

    // Task method implementations.
    // ===============================
    std::pair<bool, std::unique_ptr<FapResult>> performTask() noexcept override;
    void onAskedToCancelTask() noexcept override;

private:
    std::shared_ptr<Song> song;
    Id subsongId;
    std::unique_ptr<Task<std::unique_ptr<juce::MemoryOutputStream>>> ymExporter;

    std::unique_ptr<juce::MemoryBlock> outputStream;
};

}   // namespace arkostracker
