#pragma once

#include "../../song/instrument/sample/SamplePart.h"

namespace arkostracker
{

/**
 * This class "resamples" a sample in order to apply a new diginote.
 * This should be used when exporting a sample into a binary data, to have the new frequency applied directly.
 */
class SampleResampler
{
public:
    /** Prevents instantiation. */
    SampleResampler() = delete;

    /** @return a resampled SamplePart from the given one, according to its diginote. The output one will have a default diginote. */
    static SamplePart resample(const SamplePart& inputSamplePart) noexcept;
};

}   // namespace arkostracker
