#!/bin/bash

# Parameter 1: Input file ("ArkosTracker.zip").
# Parameter 2: File to rename the input file into ("ArkosTracker-windows-1.0.0.zip").
# Parameter 3: Version for the target folder ("1.0.0").
# Parameter 4: Target name for the target folder ("windows").

# Environment variables are also used:
# FTP_USERNAME, FTP_PASSWORD, and FTP_RELEASE_BASE_URL (such as ftp.example.net/www/mysoftware/release).

echo "Uploading..."

# Rename a simple generated file ("ArkosTracker.zip") into a more complex filename ("ArkosTracker-windows-1.0.0.zip").
mv "$1" "$2"

echo "Moving $1 to $2"

# Upload via FTP.
# Error handling: https://stackoverflow.com/questions/57120898/capturing-error-message-of-curl-in-bash-script-andchecking-status
# --no-epsv used because for windows, the installer could never be uploaded from the CI, the file was always cut short...?
if curl -v --retry 3 --max-time 900 --connect-timeout 360 --no-epsv -T "$2" "ftp://${FTP_USERNAME}:${FTP_PASSWORD}@${FTP_RELEASE_BASE_URL}/$3/$4/" --ftp-create-dirs; then
  echo "Uploaded."
else
  echo "Error!"
  exit 1
fi