
/*
 * Another World engine rewrite
 * Copyright (C) 2004-2005 Gregory Montoir (cyx@users.sourceforge.net)
 */

#include "graphics.h"
#include "mixer.h"
#include "script.h"
#include "resource.h"
#include "video.h"


const Script::OpcodeStub Script::_opTable[] = {
	/* 0x00 */
	&Script::op_movConst,
	&Script::op_mov,
	&Script::op_add,
	&Script::op_addConst,
	/* 0x04 */
	&Script::op_call,
	&Script::op_ret,
	&Script::op_yieldTask,
	&Script::op_jmp,
	/* 0x08 */
	&Script::op_installTask,
	&Script::op_jmpIfVar,
	&Script::op_condJmp,
	&Script::op_setPalette,
	/* 0x0C */
	&Script::op_changeTasksState,
	&Script::op_selectPage,
	&Script::op_fillPage,
	&Script::op_copyPage,
	/* 0x10 */
	&Script::op_updateDisplay,
	&Script::op_removeTask,
	&Script::op_drawString,
	&Script::op_sub,
	/* 0x14 */
	&Script::op_and,
	&Script::op_or,
	&Script::op_shl,
	&Script::op_shr,
	/* 0x18 */
	&Script::op_playSound,
	&Script::op_updateResources,
	&Script::op_playMusic
};

const uint16_t Script::_periodTable[] = {
	1076, 1016,  960,  906,  856,  808,  762,  720,  678,  640,
	 604,  570,  538,  508,  480,  453,  428,  404,  381,  360,
	 339,  320,  302,  285,  269,  254,  240,  226,  214,  202,
	 190,  180,  170,  160,  151,  143,  135,  127,  120,  113
};

const uint8_t Graphics::_font[] = {
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x10, 0x00,
	0x28, 0x28, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x24, 0x7E, 0x24, 0x24, 0x7E, 0x24, 0x00,
	0x08, 0x3E, 0x48, 0x3C, 0x12, 0x7C, 0x10, 0x00, 0x42, 0xA4, 0x48, 0x10, 0x24, 0x4A, 0x84, 0x00,
	0x60, 0x90, 0x90, 0x70, 0x8A, 0x84, 0x7A, 0x00, 0x08, 0x08, 0x10, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x06, 0x08, 0x10, 0x10, 0x10, 0x08, 0x06, 0x00, 0xC0, 0x20, 0x10, 0x10, 0x10, 0x20, 0xC0, 0x00,
	0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x10, 0x10, 0x7C, 0x10, 0x10, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x10, 0x10, 0x20, 0x00, 0x00, 0x00, 0x7C, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x10, 0x28, 0x10, 0x00, 0x00, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00, 0x00,
	0x78, 0x84, 0x8C, 0x94, 0xA4, 0xC4, 0x78, 0x00, 0x10, 0x30, 0x50, 0x10, 0x10, 0x10, 0x7C, 0x00,
	0x78, 0x84, 0x04, 0x08, 0x30, 0x40, 0xFC, 0x00, 0x78, 0x84, 0x04, 0x38, 0x04, 0x84, 0x78, 0x00,
	0x08, 0x18, 0x28, 0x48, 0xFC, 0x08, 0x08, 0x00, 0xFC, 0x80, 0xF8, 0x04, 0x04, 0x84, 0x78, 0x00,
	0x38, 0x40, 0x80, 0xF8, 0x84, 0x84, 0x78, 0x00, 0xFC, 0x04, 0x04, 0x08, 0x10, 0x20, 0x40, 0x00,
	0x78, 0x84, 0x84, 0x78, 0x84, 0x84, 0x78, 0x00, 0x78, 0x84, 0x84, 0x7C, 0x04, 0x08, 0x70, 0x00,
	0x00, 0x18, 0x18, 0x00, 0x00, 0x18, 0x18, 0x00, 0x00, 0x00, 0x18, 0x18, 0x00, 0x10, 0x10, 0x60,
	0x04, 0x08, 0x10, 0x20, 0x10, 0x08, 0x04, 0x00, 0x00, 0x00, 0xFE, 0x00, 0x00, 0xFE, 0x00, 0x00,
	0x20, 0x10, 0x08, 0x04, 0x08, 0x10, 0x20, 0x00, 0x7C, 0x82, 0x02, 0x0C, 0x10, 0x00, 0x10, 0x00,
	0x30, 0x18, 0x0C, 0x0C, 0x0C, 0x18, 0x30, 0x00, 0x78, 0x84, 0x84, 0xFC, 0x84, 0x84, 0x84, 0x00,
	0xF8, 0x84, 0x84, 0xF8, 0x84, 0x84, 0xF8, 0x00, 0x78, 0x84, 0x80, 0x80, 0x80, 0x84, 0x78, 0x00,
	0xF8, 0x84, 0x84, 0x84, 0x84, 0x84, 0xF8, 0x00, 0x7C, 0x40, 0x40, 0x78, 0x40, 0x40, 0x7C, 0x00,
	0xFC, 0x80, 0x80, 0xF0, 0x80, 0x80, 0x80, 0x00, 0x7C, 0x80, 0x80, 0x8C, 0x84, 0x84, 0x7C, 0x00,
	0x84, 0x84, 0x84, 0xFC, 0x84, 0x84, 0x84, 0x00, 0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x7C, 0x00,
	0x04, 0x04, 0x04, 0x04, 0x84, 0x84, 0x78, 0x00, 0x8C, 0x90, 0xA0, 0xE0, 0x90, 0x88, 0x84, 0x00,
	0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xFC, 0x00, 0x82, 0xC6, 0xAA, 0x92, 0x82, 0x82, 0x82, 0x00,
	0x84, 0xC4, 0xA4, 0x94, 0x8C, 0x84, 0x84, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00,
	0xF8, 0x84, 0x84, 0xF8, 0x80, 0x80, 0x80, 0x00, 0x78, 0x84, 0x84, 0x84, 0x84, 0x8C, 0x7C, 0x03,
	0xF8, 0x84, 0x84, 0xF8, 0x90, 0x88, 0x84, 0x00, 0x78, 0x84, 0x80, 0x78, 0x04, 0x84, 0x78, 0x00,
	0x7C, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x84, 0x84, 0x84, 0x84, 0x84, 0x84, 0x78, 0x00,
	0x84, 0x84, 0x84, 0x84, 0x84, 0x48, 0x30, 0x00, 0x82, 0x82, 0x82, 0x82, 0x92, 0xAA, 0xC6, 0x00,
	0x82, 0x44, 0x28, 0x10, 0x28, 0x44, 0x82, 0x00, 0x82, 0x44, 0x28, 0x10, 0x10, 0x10, 0x10, 0x00,
	0xFC, 0x04, 0x08, 0x10, 0x20, 0x40, 0xFC, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00,
	0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00,
	0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFE,
	0x3C, 0x30, 0x30, 0x30, 0x30, 0x30, 0x3C, 0x00, 0x00, 0x00, 0x38, 0x04, 0x3C, 0x44, 0x3C, 0x00,
	0x40, 0x40, 0x78, 0x44, 0x44, 0x44, 0x78, 0x00, 0x00, 0x00, 0x3C, 0x40, 0x40, 0x40, 0x3C, 0x00,
	0x04, 0x04, 0x3C, 0x44, 0x44, 0x44, 0x3C, 0x00, 0x00, 0x00, 0x38, 0x44, 0x7C, 0x40, 0x3C, 0x00,
	0x38, 0x44, 0x40, 0x60, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x78,
	0x40, 0x40, 0x58, 0x64, 0x44, 0x44, 0x44, 0x00, 0x10, 0x00, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00,
	0x02, 0x00, 0x02, 0x02, 0x02, 0x02, 0x42, 0x3C, 0x40, 0x40, 0x46, 0x48, 0x70, 0x48, 0x46, 0x00,
	0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x00, 0x00, 0x00, 0xEC, 0x92, 0x92, 0x92, 0x92, 0x00,
	0x00, 0x00, 0x78, 0x44, 0x44, 0x44, 0x44, 0x00, 0x00, 0x00, 0x38, 0x44, 0x44, 0x44, 0x38, 0x00,
	0x00, 0x00, 0x78, 0x44, 0x44, 0x78, 0x40, 0x40, 0x00, 0x00, 0x3C, 0x44, 0x44, 0x3C, 0x04, 0x04,
	0x00, 0x00, 0x4C, 0x70, 0x40, 0x40, 0x40, 0x00, 0x00, 0x00, 0x3C, 0x40, 0x38, 0x04, 0x78, 0x00,
	0x10, 0x10, 0x3C, 0x10, 0x10, 0x10, 0x0C, 0x00, 0x00, 0x00, 0x44, 0x44, 0x44, 0x44, 0x78, 0x00,
	0x00, 0x00, 0x44, 0x44, 0x44, 0x28, 0x10, 0x00, 0x00, 0x00, 0x82, 0x82, 0x92, 0xAA, 0xC6, 0x00,
	0x00, 0x00, 0x44, 0x28, 0x10, 0x28, 0x44, 0x00, 0x00, 0x00, 0x42, 0x22, 0x24, 0x18, 0x08, 0x30,
	0x00, 0x00, 0x7C, 0x08, 0x10, 0x20, 0x7C, 0x00, 0x60, 0x90, 0x20, 0x40, 0xF0, 0x00, 0x00, 0x00,
	0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0xFE, 0x00, 0x38, 0x44, 0xBA, 0xA2, 0xBA, 0x44, 0x38, 0x00,
	0x38, 0x44, 0x82, 0x82, 0x44, 0x28, 0xEE, 0x00, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA, 0x55, 0xAA
};

const StrEntry Video::_stringsTableFr[] = {
	{ 0x001, "P E A N U T  3000" },
	{ 0x002, "Copyright  } 1990 Peanut Computer, Inc.\nAll rights reserved.\n\nCDOS Version 5.01" },
	{ 0x003, "2" },
	{ 0x004, "3" },
	{ 0x005, "." },
	{ 0x006, "A" },
	{ 0x007, "@" },
	{ 0x008, "PEANUT 3000" },
	{ 0x00A, "R" },
	{ 0x00B, "U" },
	{ 0x00C, "N" },
	{ 0x00D, "P" },
	{ 0x00E, "R" },
	{ 0x00F, "O" },
	{ 0x010, "J" },
	{ 0x011, "E" },
	{ 0x012, "C" },
	{ 0x013, "T" },
	{ 0x014, "Shield 9A.5f Ok" },
	{ 0x015, "Flux % 5.0177 Ok" },
	{ 0x016, "CDI Vector ok" },
	{ 0x017, " %%%ddd ok" },
	{ 0x018, "Race-Track ok" },
	{ 0x019, "SYNCHROTRON" },
	{ 0x01A, "E: 23%\ng: .005\n\nRK: 77.2L\n\nopt: g+\n\n Shield:\n1: OFF\n2: ON\n3: ON\n\nP~: 1\n" },
	{ 0x01B, "ON" },
	{ 0x01C, "-" },
	{ 0x021, "|" },
	{ 0x022, "--- Etude theorique ---" },
	{ 0x023, " L'EXPERIENCE DEBUTERA DANS    SECONDES." },
	{ 0x024, "20" },
	{ 0x025, "19" },
	{ 0x026, "18" },
	{ 0x027, "4" },
	{ 0x028, "3" },
	{ 0x029, "2" },
	{ 0x02A, "1" },
	{ 0x02B, "0" },
	{ 0x02C, "L E T ' S   G O" },
	{ 0x031, "- Phase 0:\nINJECTION des particules\ndans le synchrotron" },
	{ 0x032, "- Phase 1:\nACCELERATION des particules." },
	{ 0x033, "- Phase 2:\nEJECTION des particules\nsur le bouclier." },
	{ 0x034, "A  N  A  L  Y  S  E" },
	{ 0x035, "- RESULTAT:\nProbabilites de creer de:\n ANTI-MATIERE: 91.V %\n NEUTRINO 27:  0.04 %\n NEUTRINO 424: 18 %\n" },
	{ 0x036, "Verification par la pratique O/N ?" },
	{ 0x037, "SUR ?" },
	{ 0x038, "MODIFICATION DES PARAMETRES\nRELATIFS A L'ACCELERATEUR\nDE PARTICULES (SYNCHROTRON)." },
	{ 0x039, "SIMULATION DE L'EXPERIENCE ?" },
	{ 0x03C, "t---t" },
	{ 0x03D, "000 ~" },
	{ 0x03E, ".20x14dd" },
	{ 0x03F, "gj5r5r" },
	{ 0x040, "tilgor 25%" },
	{ 0x041, "12% 33% checked" },
	{ 0x042, "D=4.2158005584" },
	{ 0x043, "d=10.00001" },
	{ 0x044, "+" },
	{ 0x045, "*" },
	{ 0x046, "% 304" },
	{ 0x047, "gurgle 21" },
	{ 0x048, "{{{{" },
	{ 0x049, "Delphine Software" },
	{ 0x04A, "By Eric Chahi" },
	{ 0x04B, "5" },
	{ 0x04C, "17" },
	{ 0x12C, "0" },
	{ 0x12D, "1" },
	{ 0x12E, "2" },
	{ 0x12F, "3" },
	{ 0x130, "4" },
	{ 0x131, "5" },
	{ 0x132, "6" },
	{ 0x133, "7" },
	{ 0x134, "8" },
	{ 0x135, "9" },
	{ 0x136, "A" },
	{ 0x137, "B" },
	{ 0x138, "C" },
	{ 0x139, "D" },
	{ 0x13A, "E" },
	{ 0x13B, "F" },
	{ 0x13C, "       CODE D'ACCES:" },
	{ 0x13D, "PRESSEZ LE BOUTON POUR CONTINUER" },
	{ 0x13E, "   ENTRER LE CODE D'ACCES" },
	{ 0x13F, "MOT DE PASSE INVALIDE !" },
	{ 0x140, "ANNULER" },
	{ 0x141, "     INSEREZ LA DISQUETTE ?\n\n\n\n\n\n\n\n\nPRESSEZ UNE TOUCHE POUR CONTINUER" },
	{ 0x142, "SELECTIONNER LES SYMBOLES CORRESPONDANTS\nA LA POSITION\nDE LA ROUE DE PROTECTION" },
	{ 0x143, "CHARGEMENT..." },
	{ 0x144, "             ERREUR" },
	{ 0x15E, "LDKD" },
	{ 0x15F, "HTDC" },
	{ 0x160, "CLLD" },
	{ 0x161, "FXLC" },
	{ 0x162, "KRFK" },
	{ 0x163, "XDDJ" },
	{ 0x164, "LBKG" },
	{ 0x165, "KLFB" },
	{ 0x166, "TTCT" },
	{ 0x167, "DDRX" },
	{ 0x168, "TBHK" },
	{ 0x169, "BRTD" },
	{ 0x16A, "CKJL" },
	{ 0x16B, "LFCK" },
	{ 0x16C, "BFLX" },
	{ 0x16D, "XJRT" },
	{ 0x16E, "HRTB" },
	{ 0x16F, "HBHK" },
	{ 0x170, "JCGB" },
	{ 0x171, "HHFL" },
	{ 0x172, "TFBB" },
	{ 0x173, "TXHF" },
	{ 0x174, "JHJL" },
	{ 0x181, "PAR" },
	{ 0x182, "ERIC CHAHI" },
	{ 0x183, "          MUSIQUES ET BRUITAGES" },
	{ 0x184, "DE" },
	{ 0x185, "JEAN-FRANCOIS FREITAS" },
	{ 0x186, "VERSION IBM PC" },
	{ 0x187, "      PAR" },
	{ 0x188, " DANIEL MORAIS" },
	{ 0x18B, "PUIS PRESSER LE BOUTON" },
	{ 0x18C, "POSITIONNER LE JOYSTICK EN HAUT A GAUCHE" },
	{ 0x18D, " POSITIONNER LE JOYSTICK AU CENTRE" },
	{ 0x18E, " POSITIONNER LE JOYSTICK EN BAS A DROITE" },
	{ 0x258, "       Conception ..... Eric Chahi" },
	{ 0x259, "    Programmation ..... Eric Chahi" },
	{ 0x25A, "     Graphismes ....... Eric Chahi" },
	{ 0x25B, "Musique de ...... Jean-francois Freitas" },
	{ 0x25C, "              Bruitages" },
	{ 0x25D, "        Jean-Francois Freitas\n             Eric Chahi" },
	{ 0x263, "               Merci a" },
	{ 0x264, "           Jesus Martinez\n\n          Daniel Morais\n\n        Frederic Savoir\n\n      Cecile Chahi\n\n    Philippe Delamarre\n\n  Philippe Ulrich\n\nSebastien Berthet\n\nPierre Gousseau" },
	{ 0x265, "Now Go Back To Another Earth" },
	{ 0x190, "Bonsoir professeur." },
	{ 0x191, "Je vois que Monsieur a pris\nsa Ferrari." },
	{ 0x192, "IDENTIFICATION" },
	{ 0x193, "Monsieur est en parfaite sante." },
	{ 0x194, "O" },
	{ 0x193, "AU BOULOT !!!\n" },
	{ 0xFFFF, 0 }
};

const StrEntry Video::_stringsTableEng[] = {
	{ 0x001, "P E A N U T  3000" },
	{ 0x002, "Copyright  } 1990 Peanut Computer, Inc.\nAll rights reserved.\n\nCDOS Version 5.01" },
	{ 0x003, "2" },
	{ 0x004, "3" },
	{ 0x005, "." },
	{ 0x006, "A" },
	{ 0x007, "@" },
	{ 0x008, "PEANUT 3000" },
	{ 0x00A, "R" },
	{ 0x00B, "U" },
	{ 0x00C, "N" },
	{ 0x00D, "P" },
	{ 0x00E, "R" },
	{ 0x00F, "O" },
	{ 0x010, "J" },
	{ 0x011, "E" },
	{ 0x012, "C" },
	{ 0x013, "T" },
	{ 0x014, "Shield 9A.5f Ok" },
	{ 0x015, "Flux % 5.0177 Ok" },
	{ 0x016, "CDI Vector ok" },
	{ 0x017, " %%%ddd ok" },
	{ 0x018, "Race-Track ok" },
	{ 0x019, "SYNCHROTRON" },
	{ 0x01A, "E: 23%\ng: .005\n\nRK: 77.2L\n\nopt: g+\n\n Shield:\n1: OFF\n2: ON\n3: ON\n\nP~: 1\n" },
	{ 0x01B, "ON" },
	{ 0x01C, "-" },
	{ 0x021, "|" },
	{ 0x022, "--- Theoretical study ---" },
	{ 0x023, " THE EXPERIMENT WILL BEGIN IN    SECONDS" },
	{ 0x024, "  20" },
	{ 0x025, "  19" },
	{ 0x026, "  18" },
	{ 0x027, "  4" },
	{ 0x028, "  3" },
	{ 0x029, "  2" },
	{ 0x02A, "  1" },
	{ 0x02B, "  0" },
	{ 0x02C, "L E T ' S   G O" },
	{ 0x031, "- Phase 0:\nINJECTION of particles\ninto synchrotron" },
	{ 0x032, "- Phase 1:\nParticle ACCELERATION." },
	{ 0x033, "- Phase 2:\nEJECTION of particles\non the shield." },
	{ 0x034, "A  N  A  L  Y  S  I  S" },
	{ 0x035, "- RESULT:\nProbability of creating:\n ANTIMATTER: 91.V %\n NEUTRINO 27:  0.04 %\n NEUTRINO 424: 18 %\n" },
	{ 0x036, "   Practical verification Y/N ?" },
	{ 0x037, "SURE ?" },
	{ 0x038, "MODIFICATION OF PARAMETERS\nRELATING TO PARTICLE\nACCELERATOR (SYNCHROTRON)." },
	{ 0x039, "       RUN EXPERIMENT ?" },
	{ 0x03C, "t---t" },
	{ 0x03D, "000 ~" },
	{ 0x03E, ".20x14dd" },
	{ 0x03F, "gj5r5r" },
	{ 0x040, "tilgor 25%" },
	{ 0x041, "12% 33% checked" },
	{ 0x042, "D=4.2158005584" },
	{ 0x043, "d=10.00001" },
	{ 0x044, "+" },
	{ 0x045, "*" },
	{ 0x046, "% 304" },
	{ 0x047, "gurgle 21" },
	{ 0x048, "{{{{" },
	{ 0x049, "Delphine Software" },
	{ 0x04A, "By Eric Chahi" },
	{ 0x04B, "  5" },
	{ 0x04C, "  17" },
	{ 0x12C, "0" },
	{ 0x12D, "1" },
	{ 0x12E, "2" },
	{ 0x12F, "3" },
	{ 0x130, "4" },
	{ 0x131, "5" },
	{ 0x132, "6" },
	{ 0x133, "7" },
	{ 0x134, "8" },
	{ 0x135, "9" },
	{ 0x136, "A" },
	{ 0x137, "B" },
	{ 0x138, "C" },
	{ 0x139, "D" },
	{ 0x13A, "E" },
	{ 0x13B, "F" },
	{ 0x13C, "        ACCESS CODE:" },
	{ 0x13D, "PRESS BUTTON OR RETURN TO CONTINUE" },
	{ 0x13E, "   ENTER ACCESS CODE" },
	{ 0x13F, "   INVALID PASSWORD !" },
	{ 0x140, "ANNULER" },
	{ 0x141, "      INSERT DISK ?\n\n\n\n\n\n\n\n\nPRESS ANY KEY TO CONTINUE" },
	{ 0x142, " SELECT SYMBOLS CORRESPONDING TO\n THE POSITION\n ON THE CODE WHEEL" },
	{ 0x143, "    LOADING..." },
	{ 0x144, "              ERROR" },
	{ 0x15E, "LDKD" },
	{ 0x15F, "HTDC" },
	{ 0x160, "CLLD" },
	{ 0x161, "FXLC" },
	{ 0x162, "KRFK" },
	{ 0x163, "XDDJ" },
	{ 0x164, "LBKG" },
	{ 0x165, "KLFB" },
	{ 0x166, "TTCT" },
	{ 0x167, "DDRX" },
	{ 0x168, "TBHK" },
	{ 0x169, "BRTD" },
	{ 0x16A, "CKJL" },
	{ 0x16B, "LFCK" },
	{ 0x16C, "BFLX" },
	{ 0x16D, "XJRT" },
	{ 0x16E, "HRTB" },
	{ 0x16F, "HBHK" },
	{ 0x170, "JCGB" },
	{ 0x171, "HHFL" },
	{ 0x172, "TFBB" },
	{ 0x173, "TXHF" },
	{ 0x174, "JHJL" },
	{ 0x181, " BY" },
	{ 0x182, "ERIC CHAHI" },
	{ 0x183, "         MUSIC AND SOUND EFFECTS" },
	{ 0x184, " " },
	{ 0x185, "JEAN-FRANCOIS FREITAS" },
	{ 0x186, "IBM PC VERSION" },
	{ 0x187, "      BY" },
	{ 0x188, " DANIEL MORAIS" },
	{ 0x18B, "       THEN PRESS FIRE" },
	{ 0x18C, " PUT THE PADDLE ON THE UPPER LEFT CORNER" },
	{ 0x18D, "PUT THE PADDLE IN CENTRAL POSITION" },
	{ 0x18E, "PUT THE PADDLE ON THE LOWER RIGHT CORNER" },
	{ 0x258, "      Designed by ..... Eric Chahi" },
	{ 0x259, "    Programmed by...... Eric Chahi" },
	{ 0x25A, "      Artwork ......... Eric Chahi" },
	{ 0x25B, "Music by ........ Jean-francois Freitas" },
	{ 0x25C, "            Sound effects" },
	{ 0x25D, "        Jean-Francois Freitas\n             Eric Chahi" },
	{ 0x263, "              Thanks To" },
	{ 0x264, "           Jesus Martinez\n\n          Daniel Morais\n\n        Frederic Savoir\n\n      Cecile Chahi\n\n    Philippe Delamarre\n\n  Philippe Ulrich\n\nSebastien Berthet\n\nPierre Gousseau" },
	{ 0x265, "Now Go Out Of This World" },
	{ 0x190, "Good evening professor." },
	{ 0x191, "I see you have driven here in your\nFerrari." },
	{ 0x192, "IDENTIFICATION" },
	{ 0x193, "Monsieur est en parfaite sante." },
	{ 0x194, "Y\n" },
	{ 0x193, "AU BOULOT !!!\n" },
	{ 0xFFFF, 0 }
};

const StrEntry Video::_stringsTableDemo[] = {
	{ 0x1F4, "Over Two Years in the Making" },
	{ 0x1F5, "   A New, State\nof the Art, Polygon\n  Graphics System" },
	{ 0x1F6, "   Comes to the\nComputer With Full\n Screen Graphics" },
	{ 0x1F7, "While conducting a nuclear fission\nexperiment at your local\nparticle accelerator ..." },
	{ 0x1F8, "Nature decides to put a little\n    extra spin on the ball" },
	{ 0x1F9, "And sends you ..." },
	{ 0x1FA, "     Out of this World\nA Cinematic Action Adventure\n from Interplay Productions\n                    \n       By Eric CHAHI      \n\n  IBM version : D.MORAIS\n" },
	{ 0xFFFF, 0 }
};

const uint16_t Video::_stringsId15th[] = {
	0x001, 0x002, 0x003, 0x004, 0x005, 0x006, 0x007, 0x008, 0x00A, 0x00B, 0x00C, 0x00D, 0x00E, 0x00F, 0x010, 0x011,
	0x012, 0x013, 0x014, 0x015, 0x016, 0x017, 0x018, 0x019, 0x01A, 0x01B, 0x01C, 0x021, 0x022, 0x023, 0x024, 0x025,
	0x026, 0x027, 0x028, 0x029, 0x02A, 0x02B, 0x02C, 0x031, 0x032, 0x033, 0x034, 0x035, 0x036, 0x037, 0x038, 0x039,
	0x03C, 0x03D, 0x03E, 0x03F, 0x040, 0x041, 0x042, 0x043, 0x044, 0x045, 0x046, 0x047, 0x048, 0x04B, 0x04C, 0x12C,
	0x12D, 0x12E, 0x12F, 0x130, 0x131, 0x132, 0x133, 0x134, 0x135, 0x136, 0x137, 0x138, 0x139, 0x13C, 0x13D, 0x13E,
	0x13F, 0x140, 0x141, 0x142, 0x143, 0x144, 0x258, 0x259, 0x25A, 0x25B, 0x25C, 0x25D, 0x25E, 0x25F, 0x260, 0x261,
	0x263, 0x264, 0x265, 0x181, 0x182, 0x183, 0x184, 0x185, 0x186, 0x187, 0x188, 0x190, 0x191, 0x192, 0x193, 0x194,
	0x193, 0x1F4, 0x1F5, 0x1F6, 0x1F7, 0x1F8, 0x1F9, 0x1FA, 0x384, 0x385, 0x386, 0x387, 0x15E, 0x17C, 0x17D, 0x15F,
	0x17A, 0x17B, 0x160, 0x164, 0x163, 0x177, 0x175, 0x161, 0x176, 0x162, 0x179, 0x165, 0x178, 0x166, 0x167, 0x168,
	0x16C, 0x16D, 0x16E, 0x16F, 0x170, 0x169, 0x172, 0x17F, 0x173, 0x17E, 0x174, 0x16A, 0x16B
};

const char *Video::_stringsTable15th[] = {
	"P E A N U T  3000",
	"Copyright  } 1990 Peanut Computer, Inc.\nAll rights reserved.\n\nCDOS Version 5.01",
	"2",
	"3",
	".",
	"A",
	"@",
	"PEANUT 3000",
	"R",
	"U",
	"N",
	"P",
	"R",
	"O",
	"J",
	"E",
	"C",
	"T",
	"Shield 9A.5f Ok",
	"Flux % 5.0177 Ok",
	"CDI Vector ok",
	" %%%ddd ok",
	"Race-Track ok",
	"SYNCHROTRON",
	"E: 23%\ng: .005\n\nRK: 77.2L\n\nopt: g+\n\n Shield:\n1: OFF\n2: ON\n3: ON\n\nP~: 1\n",
	"ON",
	"-",
	"|",
	"--- Theoretical study ---",
	" THE EXPERIMENT WILL BEGIN IN    SECONDS",
	"  20",
	"  19",
	"  18",
	"  4",
	"  3",
	"  2",
	"  1",
	"  0",
	"L E T ' S   G O",
	"- Phase 0:\nINJECTION of particles\ninto synchrotron",
	"- Phase 1:\nParticle ACCELERATION.",
	"- Phase 2:\nEJECTION of particles\non the shield.",
	"A  N  A  L  Y  S  I  S",
	"- RESULT:\nProbability of creating:\n ANTIMATTER: 91.V %\n NEUTRINO 27:  0.04 %\n NEUTRINO 424: 18 %\n",
	"   Practical verification Y/N ?",
	"SUR ?",
	"MODIFICATION OF PARAMETERS\nRELATING TO PARTICLE\nACCELERATOR (SYNCHROTRON).",
	"       RUN EXPERIMENT ?",
	"t---t",
	"000 ~",
	".20x14dd",
	"gj5r5r",
	"tilgor 25%",
	"12% 33% checked",
	"D=4.2158005584",
	"d=10.00001",
	"+",
	"*",
	"% 304",
	"gurgle 21",
	"{{{{",
	"  5",
	"  17",
	"   N C B F G H",
	"   T A K R P X",
	"N",
	"C",
	"B",
	"F",
	"G",
	"H",
	"T",
	"A",
	"K",
	"R",
	"X",
	"P",
	"        ACCESS CODE:",
	"    PRESS BUTTON TO CONTINUE",
	"   ENTER ACCESS CODE",
	"   PASSWORD INVALID!",
	"ANNULER",
	"Burp !",
	"I want to believe",
	"    LOADING...",
	"              ERROR",
	"      Designed, program & artwork\n            by Eric Chahi",
	"            ",
	"     Music by J.F Freitas, Elmobo",
	"     PC Port (www.ManaGames.com):\n     ManuTOO (aka Emmanuel Rivoire)\n ",
	"            Sound effects:",
	"  Jean-Francois Freitas, Eric Chahi\n\n  Additional Gfx: Bertrand Dupuy (menu)",
	"         -----",
	"    ----------",
	"             \n\n",
	"            \n\n          ",
	"              Thanks To",
	"           Jesus Martinez\n\n          Daniel Morais\n\n        Pierre Gousseau\n\n      Cecile Chahi\n\n    Philippe Delamarre\n\n  Frederic Sardain\n\nSebastien Berthet",
	"Now Go Back To Another Earth",
	" BY",
	"ERIC CHAHI",
	"         MUSIC AND SOUND EFFECTS",
	"",
	"JEAN-FRANCOIS FREITAS",
	" GBA VERSION",
	"      BY",
	"CYRIL COGORDAN",
	"Good evening professor.",
	"I see you have driven here in your\nFerrari.",
	"IDENTIFICATION",
	"Monsieur est en parfaite sante.",
	"Y",
	"AU BOULOT !!!\n",
	"Over Two Years in the Making",
	"   A New, State\nof the Art, Polygon\n  Graphics System",
	"   Comes to the\nComputer With Full\n Screen Graphics",
	"While conducting a nuclear fission\nexperiment at your local\nparticle accelerator ...",
	"Nature decides to put a little\n    extra spin on the ball",
	"And sends you ...",
	"     Another World\nA Cinematic Action Adventure\n Coming soon to a computer\n      screen near you\n from ??????? Productions\n   ",
	"P A U S E",
	"CONTINUE",
	"EXIT",
	"*",
	"KBAB",
	"KNNN",
	"KFBN",
	"HPBC",
	"XACN",
	"KNTC",
	"CKKB",
	"KNAG",
	"XBBT",
	"BGAF",
	"RNTA",
	"FXKC",
	"RABH",
	"ARFA",
	"FRPX",
	"AKFN",
	"GKHH",
	"PPCP",
	"BBRX",
	"PNHA",
	"NFKX",
	"XTRP",
	"HRPN",
	"HNHA",
	"TCGN",
	"NRPB",
	"PFNN",
	"CRGN",
	"PXHF",
	"XXKF",
	"THTK",
	"CATK",
	"KFCA",
};

const char *Video::_str0x194AtariDemo = "Je signale que Monsieur\na tout de meme 40 minutes\net 21 secondes de retard.";

const StrEntry Video::_stringsTable3DO[] = {
	{ 1, "Copyright } 1997 Cortland Computer, Inc.\nAll rights reserved.\n\nGS/OS Version 7.03\nII Infinitum!" },
	{ 2, "Copyright } 1997 Peanut Computer, Inc.\nAll rights reserved.\n\nOS/BH Version 7.03" },
	{ 3, "2" },
	{ 4, "3" },
	{ 5, "." },
	{ 6, "A" },
	{ 7, "@" },
	{ 10, "R" },
	{ 11, "U" },
	{ 12, "N" },
	{ 13, "P" },
	{ 14, "R" },
	{ 15, "O" },
	{ 16, "J" },
	{ 17, "E" },
	{ 18, "C" },
	{ 19, "T" },
	{ 20, "Shield 9A.5f Ok" },
	{ 21, "Flux % 5.0177 Ok" },
	{ 22, "CDI Vector ok" },
	{ 23, " %%%ddd ok" },
	{ 24, "Race-Track ok" },
	{ 25, "SYNCHROTRON" },
	{ 26, "E: 23%\ng: .005\n\nRK: 77.2L\n\nopt: g+\n\n Shield:\n1: OFF\n2: ON\n3: ON\n\nP~: 1\n" },
	{ 27, "ON" },
	{ 28, "-" },
	{ 33, "|" },
	{ 34, "--- Theoretical study ---" },
	{ 35, " THE EXPERIMENT WILL BEGIN IN    SECONDS" },
	{ 36, "  20" },
	{ 37, "  19" },
	{ 38, "  18" },
	{ 39, "  4" },
	{ 40, "  3" },
	{ 41, "  2" },
	{ 42, "  1" },
	{ 43, "  0" },
	{ 49, "- Phase 1:\nINJECTION of particles\ninto synchrotron" },
	{ 50, "- Phase 2:\nParticle ACCELERATION." },
	{ 51, "- Phase 3:\nEJECTION of particles\non the shield." },
	{ 52, "   A N A L Y S I S" },
	{ 53, "- RESULT:\nProbability of creating:\n ANTIMATTER  : 91.20 %\n NEUTRINO 27 :  0.04 %\n NEUTRINO 424: 18.02 %\n" },
	{ 54, "   Practical verification Y/N ?" },
	{ 55, "SURE ?" },
	{ 56, "MODIFICATION OF PARAMETERS\nRELATING TO PARTICLE\nACCELERATOR (SYNCHROTRON)." },
	{ 57, "       RUN EXPERIMENT ?" },
	{ 60, "t---t" },
	{ 61, "000 ~" },
	{ 62, ".20x14dd" },
	{ 63, "gj5r5r" },
	{ 64, "tilgor 25%" },
	{ 65, "12% 33% checked" },
	{ 66, "D=4.2158005584" },
	{ 67, "d=10.00001" },
	{ 68, "+" },
	{ 69, "*" },
	{ 70, "% 304" },
	{ 71, "gurgle 21" },
	{ 72, "{{{{" },
	{ 75, "  5" },
	{ 76, "  17" },
	{ 300, "   B C D F G H" },
	{ 301, "   J K L R T X" },
	{ 302, "B" },
	{ 303, "C" },
	{ 304, "D" },
	{ 305, "F" },
	{ 306, "G" },
	{ 307, "H" },
	{ 308, "J" },
	{ 309, "K" },
	{ 310, "L" },
	{ 311, "R" },
	{ 312, "X" },
	{ 313, "T" },
	{ 316, "        ACCESS CODE:" },
	{ 317, "  PRESS BUTTON TO CONTINUE" },
	{ 318, "    PRESS BUTTON TO CONTINUE" },
	{ 319, "   PASSWORD INVALID!" },
	{ 320, "INVALID" },
	{ 350, "LDKD" },
	{ 351, "HTDC" },
	{ 352, "CLLD" },
	{ 353, "FXLC" },
	{ 354, "KRFK" },
	{ 355, "XDDJ" },
	{ 356, "LBKG" },
	{ 357, "KLFB" },
	{ 358, "TTCT" },
	{ 359, "DDRX" },
	{ 360, "TBHK" },
	{ 361, "BRTD" },
	{ 362, "CKJL" },
	{ 363, "LFCK" },
	{ 364, "BFLX" },
	{ 365, "XJRT" },
	{ 366, "HRTB" },
	{ 367, "HBHK" },
	{ 368, "JCGB" },
	{ 369, "HHFL" },
	{ 370, "TFBB" },
	{ 371, "TXHF" },
	{ 372, "JHJL" },
	{ 400, "Good evening professor." },
	{ 401, "I see you have driven here in your\nFerrari." },
	{ 402, "IDENTIFICATION" },
	{ 404, "Y" },
	{ 0xFFFF, 0 }
};

const char *Video::_noteText3DO = {
	"From the diary of Lester Knight\n"
	"Chaykin.\n"
	"\n"
	" I am taking advantage of this\n"
	"short period of rest to record\n"
	"some useful information in my\n"
	"notebook which has survived my\n"
	"recent adventures.  I am now\n"
	"separated from my companion whom\n"
	"without his help I would still\n"
	"be trapped. I hope I manage to\n"
	"find him. I owe him my life.\n"
	"\n"
	" Right now I am lost in a maze\n"
	"of underground corridors.  I\n"
	"cannot tell how long I have been\n"
	"wandering. And I constantly\n"
	"encounter streams that threaten\n"
	"to flood these corridors at any\n"
	"time.\n"
	"\n"
	" Luckily I have found a weapon\n"
	"that can blast a hole in almost\n"
	"anything that I find.  It has\n"
	"saved my life countless times.\n"
	"\n"
	" There are many guards roaming\n"
	"these corridors.  I must be\n"
	"moving along before I...\n"
};

const char *Video::_endText3DO = {
	"Original Programming, Artwork, &\n"
	"Design\n"
	"Eric Chahi\n"
	"\n"
	"Executive Producer\n"
	"Brian Fargo\n"
	"\n"
	"Producer\n"
	"Michael Conti\n"
	"\n"
	"Programming / Scriptor\n"
	"Burger Bill Heineman\n"
	"\n"
	"Music Composition\n"
	"Andrew Dimitroff\n"
	"\n"
	"Music Engineers\n"
	"Nick Carr and Sheridan Eldridge\n"
	"\n"
	"Background Graphics\n"
	"Lil' Gangsters Entertainment\n"
	"\n"
	"Background Editing\n"
	"Lars Brubaker\n"
	"\n"
	"Additional Artwork\n"
	"George Almond, Eddie Rainwater\n"
	"Larry Fukuoka, Lars Brubaker,\n"
	"Kevin Beardslee\n"
	"\n"
	"Sound Design\n"
	"Paradise Post Production\n"
	"\n"
	"Sound Effects\n"
	"Clive Mizumoto & Ron Salaises\n"
	"\n"
	"Music Mastering and Editing\n"
	"Charles Deenen\n"
	"\n"
	"Sound Effects Editing\n"
	"Brian Luzietti\n"
	"\n"
	"Line Producer\n"
	"Lars Brubaker\n"
	"\n"
	"Opening Title Sequence\n"
	"Ed Trillo\n"
	"\n"
	"Interplay Logo Rendering\n"
	"Tony Bowren\n"
	"\n"
	"Director of Quality Assurance\n"
	"Kirk Tome\n"
	"\n"
	"Testing\n"
	"Jason Taylor, Bill Church,\n"
	"Todd Loenhorst\n"
	"\n"
	"Manual Editor\n"
	"Scott Bennie\n"
	"\n"
	"Layout Design\n"
	"Larry Fukuoka\n"
	"\n"
	"Project Leader\n"
	"Burger Bill Heineman\n"
	"\n"
	"Special thanks to\n"
	"Bill \"Angus\" Guschwan at 3DO\n"
};

static const uint8_t _verticesData3DO[] = {
	0x0f, 0x10, 0x05, 0x10, 0x05, 0x0f, 0x05, 0x0e, 0x04, 0x0e, 0x04, 0x0d, 0x03, 0x0c, 0x03, 0x0b,
	0x02, 0x0b, 0x02, 0x0a, 0x01, 0x09, 0x01, 0x08, 0x01, 0x08, 0x01, 0x07, 0x01, 0x06, 0x01, 0x06,
	0x01, 0x06, 0x00, 0x05, 0x0b, 0x17, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07,
	0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x08, 0x03, 0x09, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0a,
	0x05, 0x0b, 0x06, 0x0b, 0x0e, 0x0c, 0x03, 0x0b, 0x04, 0x0b, 0x05, 0x0a, 0x05, 0x0a, 0x05, 0x0b,
	0x05, 0x0b, 0x06, 0x0b, 0x06, 0x0c, 0x06, 0x0c, 0x04, 0x0c, 0x03, 0x0d, 0x01, 0x0d, 0x00, 0x00,
	0x0f, 0x0f, 0x07, 0x09, 0x07, 0x0b, 0x08, 0x0d, 0x08, 0x0f, 0x08, 0x0e, 0x08, 0x0e, 0x07, 0x0d,
	0x06, 0x0c, 0x02, 0x0c, 0x00, 0x0b, 0x02, 0x0b, 0x04, 0x0b, 0x06, 0x0b, 0x08, 0x0b, 0x0a, 0x0b,
	0x0d, 0x1e, 0x06, 0x08, 0x04, 0x09, 0x03, 0x09, 0x02, 0x0a, 0x02, 0x0b, 0x01, 0x0b, 0x01, 0x0c,
	0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b,
	0x01, 0x0b, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x02, 0x0c, 0x07, 0x0b, 0x00, 0x00,
	0x10, 0x11, 0x06, 0x10, 0x05, 0x0f, 0x05, 0x0f, 0x04, 0x0e, 0x04, 0x0d, 0x03, 0x0c, 0x02, 0x0c,
	0x02, 0x0b, 0x01, 0x0a, 0x01, 0x09, 0x01, 0x08, 0x01, 0x07, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06,
	0x00, 0x06, 0x00, 0x06, 0x0b, 0x18, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06,
	0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07,
	0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x08, 0x03, 0x09, 0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b,
	0x06, 0x0b, 0x06, 0x0b, 0x07, 0x0b, 0x00, 0x00, 0x10, 0x0f, 0x07, 0x08, 0x07, 0x0a, 0x07, 0x0c,
	0x08, 0x0d, 0x08, 0x0f, 0x08, 0x10, 0x07, 0x0e, 0x07, 0x0d, 0x00, 0x0c, 0x02, 0x0c, 0x03, 0x0c,
	0x05, 0x0c, 0x07, 0x0b, 0x08, 0x0b, 0x0a, 0x0b, 0x0e, 0x13, 0x04, 0x0e, 0x04, 0x0d, 0x03, 0x0d,
	0x03, 0x0c, 0x02, 0x0c, 0x02, 0x0b, 0x01, 0x0a, 0x01, 0x0a, 0x00, 0x09, 0x00, 0x08, 0x00, 0x07,
	0x00, 0x06, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
	0x10, 0x15, 0x00, 0x08, 0x00, 0x08, 0x01, 0x08, 0x01, 0x08, 0x01, 0x09, 0x02, 0x09, 0x02, 0x09,
	0x02, 0x09, 0x03, 0x09, 0x03, 0x09, 0x03, 0x09, 0x04, 0x09, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0a,
	0x05, 0x0a, 0x06, 0x0b, 0x07, 0x0c, 0x07, 0x0d, 0x08, 0x0e, 0x09, 0x0f, 0x0f, 0x0e, 0x01, 0x0b,
	0x03, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x06, 0x0c, 0x06, 0x0c,
	0x05, 0x0d, 0x05, 0x0d, 0x04, 0x0e, 0x03, 0x0c, 0x01, 0x06, 0x00, 0x00, 0x11, 0x0f, 0x08, 0x09,
	0x08, 0x0b, 0x08, 0x0d, 0x09, 0x0e, 0x09, 0x10, 0x09, 0x11, 0x09, 0x0f, 0x08, 0x0e, 0x07, 0x0d,
	0x05, 0x0d, 0x03, 0x0d, 0x01, 0x0d, 0x02, 0x0d, 0x06, 0x0d, 0x0a, 0x0d, 0x0d, 0x1e, 0x05, 0x08,
	0x04, 0x09, 0x03, 0x09, 0x02, 0x0a, 0x02, 0x0b, 0x01, 0x0b, 0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d,
	0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0c, 0x01, 0x0c, 0x00, 0x0c,
	0x00, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x03, 0x0d, 0x09, 0x0d, 0x00, 0x00, 0x0d, 0x14, 0x04, 0x0d,
	0x04, 0x0d, 0x03, 0x0c, 0x03, 0x0c, 0x03, 0x0b, 0x02, 0x0b, 0x02, 0x0a, 0x02, 0x09, 0x01, 0x09,
	0x01, 0x08, 0x01, 0x07, 0x00, 0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x00, 0x00, 0x12, 0x14, 0x00, 0x08, 0x00, 0x08, 0x01, 0x08,
	0x01, 0x09, 0x01, 0x09, 0x02, 0x09, 0x02, 0x09, 0x02, 0x09, 0x03, 0x0a, 0x03, 0x0a, 0x03, 0x0a,
	0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x06, 0x0d, 0x07, 0x0e, 0x08, 0x0f,
	0x09, 0x11, 0x00, 0x00, 0x0e, 0x0f, 0x07, 0x0a, 0x05, 0x0a, 0x03, 0x09, 0x01, 0x09, 0x02, 0x09,
	0x03, 0x0a, 0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x06, 0x0c, 0x06, 0x0d, 0x05, 0x0d, 0x04, 0x0b,
	0x02, 0x08, 0x01, 0x06, 0x0f, 0x0c, 0x06, 0x0f, 0x06, 0x0e, 0x07, 0x0d, 0x07, 0x0d, 0x07, 0x0d,
	0x07, 0x0d, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x04, 0x0c, 0x03, 0x0d, 0x01, 0x0d, 0x00, 0x00,
	0x0c, 0x13, 0x02, 0x0c, 0x02, 0x0b, 0x02, 0x0b, 0x01, 0x0a, 0x01, 0x0a, 0x01, 0x09, 0x01, 0x08,
	0x01, 0x08, 0x00, 0x07, 0x00, 0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x0b, 0x13, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x08, 0x01, 0x0b, 0x03, 0x0b, 0x04, 0x0b,
	0x0f, 0x10, 0x06, 0x09, 0x05, 0x09, 0x03, 0x0a, 0x02, 0x0a, 0x01, 0x0b, 0x01, 0x0b, 0x03, 0x0c,
	0x05, 0x0d, 0x07, 0x0e, 0x08, 0x0f, 0x07, 0x0e, 0x07, 0x0c, 0x06, 0x0b, 0x06, 0x0a, 0x05, 0x08,
	0x05, 0x07, 0x00, 0x00, 0x0a, 0x13, 0x02, 0x0a, 0x02, 0x0a, 0x02, 0x09, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x01, 0x08, 0x01, 0x08, 0x00, 0x08, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07,
	0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x02, 0x07, 0x02, 0x07, 0x0e, 0x0c, 0x05, 0x0e,
	0x05, 0x0d, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c,
	0x04, 0x0c, 0x03, 0x0d, 0x01, 0x0d, 0x00, 0x00, 0x0d, 0x1e, 0x07, 0x08, 0x05, 0x09, 0x03, 0x09,
	0x02, 0x0a, 0x02, 0x0b, 0x01, 0x0b, 0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d,
	0x00, 0x0d, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0b, 0x01, 0x0b,
	0x01, 0x0a, 0x01, 0x0a, 0x01, 0x0a, 0x01, 0x0b, 0x01, 0x0b, 0x00, 0x0b, 0x00, 0x0c, 0x00, 0x0c,
	0x02, 0x0b, 0x04, 0x0b, 0x06, 0x0a, 0x00, 0x00, 0x07, 0x12, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x07, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x02, 0x07, 0x00, 0x00,
	0x0d, 0x15, 0x05, 0x0d, 0x05, 0x0c, 0x04, 0x0c, 0x04, 0x0b, 0x03, 0x0b, 0x03, 0x0a, 0x03, 0x0a,
	0x02, 0x09, 0x02, 0x09, 0x02, 0x08, 0x01, 0x08, 0x01, 0x07, 0x00, 0x07, 0x00, 0x06, 0x01, 0x07,
	0x02, 0x09, 0x03, 0x0a, 0x04, 0x0b, 0x05, 0x0c, 0x05, 0x0c, 0x06, 0x0b, 0x08, 0x12, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x06, 0x01, 0x06, 0x02, 0x07,
	0x02, 0x07, 0x00, 0x00, 0x0d, 0x12, 0x04, 0x0d, 0x04, 0x0c, 0x03, 0x0c, 0x03, 0x0b, 0x03, 0x0b,
	0x02, 0x0a, 0x02, 0x0a, 0x02, 0x09, 0x01, 0x08, 0x01, 0x08, 0x01, 0x07, 0x00, 0x07, 0x00, 0x06,
	0x00, 0x06, 0x01, 0x07, 0x01, 0x07, 0x02, 0x08, 0x02, 0x08, 0x00, 0x00, 0x0e, 0x0e, 0x07, 0x0d,
	0x04, 0x0c, 0x05, 0x0c, 0x05, 0x0c, 0x06, 0x0b, 0x06, 0x0b, 0x07, 0x0b, 0x07, 0x0b, 0x06, 0x0c,
	0x06, 0x0c, 0x05, 0x0d, 0x05, 0x0d, 0x03, 0x0c, 0x01, 0x07, 0x00, 0x00, 0x11, 0x1f, 0x0c, 0x0f,
	0x0b, 0x10, 0x0b, 0x10, 0x0a, 0x11, 0x0a, 0x11, 0x0a, 0x10, 0x0a, 0x10, 0x0a, 0x0f, 0x0a, 0x0f,
	0x0a, 0x0f, 0x0a, 0x0e, 0x0a, 0x0e, 0x0a, 0x0d, 0x0a, 0x0d, 0x08, 0x0d, 0x07, 0x0d, 0x06, 0x0d,
	0x06, 0x0d, 0x06, 0x0c, 0x06, 0x0c, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0a, 0x04, 0x09, 0x02, 0x07,
	0x01, 0x06, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x01, 0x04, 0x02, 0x04, 0x12, 0x1e, 0x0d, 0x10,
	0x0c, 0x11, 0x0c, 0x11, 0x0b, 0x12, 0x0b, 0x12, 0x0b, 0x11, 0x0b, 0x11, 0x0b, 0x10, 0x0b, 0x10,
	0x0b, 0x10, 0x0b, 0x0f, 0x0b, 0x0f, 0x0b, 0x0e, 0x0b, 0x0e, 0x09, 0x0e, 0x07, 0x0e, 0x06, 0x0e,
	0x06, 0x0d, 0x06, 0x0c, 0x06, 0x0c, 0x05, 0x0b, 0x05, 0x0a, 0x05, 0x09, 0x03, 0x07, 0x01, 0x06,
	0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x01, 0x04, 0x02, 0x04, 0x00, 0x00, 0x0f, 0x1f, 0x0b, 0x0e,
	0x0a, 0x0e, 0x0a, 0x0f, 0x09, 0x0f, 0x09, 0x0f, 0x09, 0x0e, 0x09, 0x0e, 0x09, 0x0e, 0x09, 0x0e,
	0x09, 0x0d, 0x09, 0x0d, 0x09, 0x0d, 0x09, 0x0c, 0x09, 0x0c, 0x07, 0x0c, 0x06, 0x0c, 0x05, 0x0c,
	0x05, 0x0c, 0x05, 0x0b, 0x05, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x09, 0x03, 0x08, 0x02, 0x06,
	0x01, 0x05, 0x00, 0x04, 0x00, 0x04, 0x01, 0x04, 0x01, 0x04, 0x02, 0x04, 0x0d, 0x20, 0x09, 0x0b,
	0x08, 0x0c, 0x08, 0x0c, 0x07, 0x0d, 0x07, 0x0d, 0x07, 0x0d, 0x07, 0x0c, 0x07, 0x0c, 0x07, 0x0c,
	0x08, 0x0c, 0x08, 0x0c, 0x08, 0x0b, 0x08, 0x0b, 0x08, 0x0b, 0x06, 0x0b, 0x05, 0x0b, 0x04, 0x0b,
	0x04, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x03, 0x09, 0x03, 0x09, 0x03, 0x08, 0x02, 0x07, 0x02, 0x06,
	0x01, 0x05, 0x00, 0x04, 0x00, 0x04, 0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x02, 0x04, 0x00, 0x00,
	0x0b, 0x21, 0x07, 0x09, 0x06, 0x0a, 0x06, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0a,
	0x05, 0x0a, 0x05, 0x0a, 0x06, 0x0a, 0x06, 0x0a, 0x06, 0x09, 0x06, 0x09, 0x06, 0x09, 0x05, 0x09,
	0x04, 0x09, 0x03, 0x09, 0x03, 0x09, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x07,
	0x03, 0x07, 0x02, 0x06, 0x02, 0x05, 0x01, 0x05, 0x01, 0x04, 0x00, 0x03, 0x00, 0x03, 0x01, 0x03,
	0x01, 0x04, 0x02, 0x04, 0x08, 0x21, 0x04, 0x06, 0x03, 0x07, 0x03, 0x07, 0x02, 0x08, 0x02, 0x08,
	0x02, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x07, 0x03, 0x07, 0x04, 0x07, 0x04, 0x07,
	0x04, 0x07, 0x03, 0x07, 0x02, 0x08, 0x01, 0x08, 0x01, 0x08, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07,
	0x02, 0x07, 0x02, 0x06, 0x02, 0x06, 0x02, 0x05, 0x01, 0x05, 0x01, 0x04, 0x00, 0x04, 0x00, 0x03,
	0x00, 0x03, 0x00, 0x03, 0x01, 0x04, 0x01, 0x04, 0x07, 0x21, 0x03, 0x05, 0x02, 0x06, 0x02, 0x06,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x06, 0x02, 0x06,
	0x03, 0x06, 0x03, 0x06, 0x03, 0x06, 0x02, 0x06, 0x01, 0x07, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x01, 0x06, 0x01, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x05, 0x01, 0x05,
	0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x02, 0x05, 0x02, 0x05, 0x07, 0x21, 0x02, 0x04,
	0x01, 0x05, 0x01, 0x05, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06,
	0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x03, 0x06, 0x03, 0x06, 0x02, 0x06, 0x01, 0x07, 0x00, 0x07,
	0x00, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x01, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x06,
	0x02, 0x06, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x03, 0x06, 0x03, 0x06,
	0x09, 0x21, 0x02, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06, 0x01, 0x06,
	0x01, 0x06, 0x01, 0x06, 0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x07, 0x03, 0x07, 0x02, 0x07,
	0x02, 0x08, 0x01, 0x08, 0x01, 0x08, 0x01, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x07, 0x02, 0x07,
	0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x04, 0x07, 0x04, 0x07, 0x04, 0x07,
	0x04, 0x08, 0x04, 0x08, 0x0e, 0x0c, 0x03, 0x0b, 0x03, 0x0a, 0x04, 0x09, 0x04, 0x09, 0x03, 0x09,
	0x03, 0x09, 0x03, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x0a, 0x01, 0x0b, 0x01, 0x0d, 0x00, 0x00,
	0x0b, 0x17, 0x04, 0x0b, 0x04, 0x0b, 0x04, 0x0b, 0x04, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a,
	0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x09, 0x04, 0x09, 0x04, 0x09,
	0x04, 0x09, 0x03, 0x08, 0x02, 0x08, 0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x00, 0x06, 0x00, 0x05,
	0x0f, 0x10, 0x00, 0x0a, 0x01, 0x0a, 0x01, 0x0b, 0x02, 0x0b, 0x03, 0x0c, 0x04, 0x0c, 0x04, 0x0d,
	0x05, 0x0d, 0x06, 0x0e, 0x07, 0x0e, 0x07, 0x0e, 0x08, 0x0e, 0x09, 0x0e, 0x09, 0x0e, 0x09, 0x0e,
	0x0a, 0x0f, 0x00, 0x00, 0x0f, 0x0f, 0x06, 0x08, 0x04, 0x08, 0x02, 0x07, 0x00, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x02, 0x08, 0x03, 0x09, 0x03, 0x0d, 0x04, 0x0f, 0x04, 0x0d, 0x04, 0x0b, 0x04, 0x09,
	0x04, 0x07, 0x04, 0x05, 0x0d, 0x1e, 0x05, 0x07, 0x04, 0x09, 0x04, 0x0a, 0x03, 0x0b, 0x02, 0x0b,
	0x02, 0x0c, 0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0c,
	0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0b,
	0x02, 0x06, 0x00, 0x00, 0x10, 0x11, 0x00, 0x0a, 0x01, 0x0b, 0x01, 0x0b, 0x02, 0x0c, 0x03, 0x0c,
	0x04, 0x0d, 0x04, 0x0e, 0x05, 0x0e, 0x06, 0x0f, 0x07, 0x0f, 0x08, 0x0f, 0x09, 0x0f, 0x0a, 0x0f,
	0x0a, 0x0f, 0x0a, 0x0f, 0x0a, 0x10, 0x0a, 0x10, 0x0b, 0x18, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b,
	0x05, 0x0b, 0x05, 0x0a, 0x05, 0x0a, 0x05, 0x0a, 0x05, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a,
	0x04, 0x0a, 0x04, 0x09, 0x04, 0x09, 0x04, 0x09, 0x04, 0x09, 0x03, 0x08, 0x02, 0x08, 0x01, 0x07,
	0x00, 0x06, 0x00, 0x06, 0x00, 0x05, 0x00, 0x05, 0x00, 0x04, 0x00, 0x00, 0x0a, 0x0a, 0x01, 0x07,
	0x01, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x09, 0x00, 0x07,
	0x01, 0x06, 0x00, 0x00, 0x10, 0x0f, 0x08, 0x09, 0x06, 0x09, 0x04, 0x09, 0x03, 0x08, 0x01, 0x08,
	0x00, 0x08, 0x02, 0x09, 0x03, 0x09, 0x04, 0x10, 0x04, 0x0e, 0x04, 0x0d, 0x04, 0x0b, 0x05, 0x09,
	0x05, 0x08, 0x05, 0x06, 0x0e, 0x13, 0x00, 0x0a, 0x01, 0x0a, 0x01, 0x0b, 0x02, 0x0b, 0x02, 0x0c,
	0x03, 0x0c, 0x04, 0x0d, 0x04, 0x0d, 0x05, 0x0e, 0x06, 0x0e, 0x07, 0x0e, 0x08, 0x0e, 0x09, 0x0e,
	0x09, 0x0e, 0x09, 0x0e, 0x08, 0x0e, 0x08, 0x0e, 0x08, 0x0e, 0x08, 0x0e, 0x10, 0x15, 0x08, 0x10,
	0x08, 0x10, 0x08, 0x0f, 0x08, 0x0f, 0x07, 0x0f, 0x07, 0x0e, 0x07, 0x0e, 0x07, 0x0e, 0x07, 0x0d,
	0x07, 0x0d, 0x07, 0x0d, 0x07, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0b, 0x06, 0x0b, 0x05, 0x0a,
	0x04, 0x09, 0x03, 0x09, 0x02, 0x08, 0x01, 0x07, 0x0f, 0x0e, 0x04, 0x0e, 0x04, 0x0c, 0x05, 0x0b,
	0x05, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x03, 0x09, 0x03, 0x09, 0x02, 0x0a, 0x02, 0x0a,
	0x01, 0x0b, 0x03, 0x0c, 0x09, 0x0e, 0x00, 0x00, 0x11, 0x0f, 0x08, 0x09, 0x06, 0x09, 0x04, 0x09,
	0x03, 0x08, 0x01, 0x08, 0x00, 0x08, 0x02, 0x08, 0x03, 0x09, 0x04, 0x0a, 0x04, 0x0c, 0x04, 0x0e,
	0x04, 0x10, 0x04, 0x0f, 0x04, 0x0b, 0x04, 0x07, 0x0d, 0x14, 0x00, 0x09, 0x00, 0x09, 0x01, 0x0a,
	0x01, 0x0a, 0x02, 0x0a, 0x02, 0x0b, 0x03, 0x0b, 0x04, 0x0b, 0x04, 0x0c, 0x05, 0x0c, 0x06, 0x0c,
	0x06, 0x0d, 0x07, 0x0d, 0x07, 0x0d, 0x07, 0x0d, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c,
	0x07, 0x0c, 0x00, 0x00, 0x12, 0x14, 0x0a, 0x12, 0x0a, 0x12, 0x0a, 0x11, 0x09, 0x11, 0x09, 0x11,
	0x09, 0x10, 0x09, 0x10, 0x09, 0x10, 0x08, 0x0f, 0x08, 0x0f, 0x08, 0x0f, 0x08, 0x0e, 0x08, 0x0e,
	0x07, 0x0e, 0x07, 0x0d, 0x07, 0x0d, 0x05, 0x0c, 0x04, 0x0b, 0x03, 0x0a, 0x01, 0x09, 0x00, 0x00,
	0x0f, 0x0c, 0x00, 0x09, 0x01, 0x09, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x03, 0x09,
	0x03, 0x09, 0x03, 0x09, 0x03, 0x0b, 0x02, 0x0c, 0x02, 0x0e, 0x00, 0x00, 0x0c, 0x13, 0x00, 0x0a,
	0x01, 0x0a, 0x01, 0x0a, 0x02, 0x0b, 0x02, 0x0b, 0x03, 0x0b, 0x04, 0x0b, 0x04, 0x0b, 0x05, 0x0c,
	0x05, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x06, 0x0c, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b,
	0x05, 0x0b, 0x06, 0x0b, 0x0b, 0x13, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a,
	0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b,
	0x05, 0x0b, 0x05, 0x0b, 0x03, 0x0b, 0x00, 0x0a, 0x00, 0x08, 0x00, 0x07, 0x0f, 0x10, 0x06, 0x09,
	0x06, 0x0a, 0x05, 0x0c, 0x05, 0x0d, 0x04, 0x0e, 0x04, 0x0e, 0x03, 0x0c, 0x02, 0x0a, 0x01, 0x08,
	0x00, 0x07, 0x01, 0x08, 0x03, 0x08, 0x04, 0x09, 0x05, 0x09, 0x07, 0x0a, 0x08, 0x0a, 0x00, 0x00,
	0x0d, 0x1e, 0x05, 0x08, 0x04, 0x09, 0x04, 0x0a, 0x03, 0x0b, 0x02, 0x0b, 0x02, 0x0c, 0x01, 0x0c,
	0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0d, 0x01, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0a, 0x00, 0x04, 0x00, 0x00,
	0x0a, 0x13, 0x00, 0x08, 0x00, 0x08, 0x01, 0x08, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x02, 0x09,
	0x02, 0x09, 0x02, 0x0a, 0x03, 0x0a, 0x03, 0x0a, 0x03, 0x0a, 0x03, 0x0a, 0x04, 0x09, 0x04, 0x09,
	0x04, 0x09, 0x04, 0x09, 0x03, 0x08, 0x03, 0x08, 0x0e, 0x0c, 0x00, 0x09, 0x01, 0x09, 0x02, 0x08,
	0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x0a, 0x01, 0x0b,
	0x01, 0x0d, 0x00, 0x00, 0x0d, 0x1e, 0x05, 0x06, 0x04, 0x08, 0x04, 0x0a, 0x03, 0x0b, 0x02, 0x0b,
	0x02, 0x0c, 0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0c,
	0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x03, 0x0c, 0x03, 0x0c,
	0x03, 0x0c, 0x02, 0x0c, 0x02, 0x0c, 0x02, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x02, 0x0b, 0x02, 0x09,
	0x03, 0x07, 0x00, 0x00, 0x07, 0x12, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x07,
	0x02, 0x07, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x00, 0x05, 0x00, 0x00, 0x0d, 0x15, 0x00, 0x08,
	0x01, 0x08, 0x01, 0x09, 0x02, 0x09, 0x02, 0x0a, 0x03, 0x0a, 0x03, 0x0a, 0x04, 0x0b, 0x04, 0x0b,
	0x05, 0x0b, 0x05, 0x0c, 0x06, 0x0c, 0x06, 0x0d, 0x07, 0x0d, 0x06, 0x0c, 0x04, 0x0b, 0x03, 0x0a,
	0x02, 0x09, 0x01, 0x08, 0x01, 0x08, 0x02, 0x07, 0x08, 0x12, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08,
	0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x03, 0x08,
	0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x02, 0x07, 0x02, 0x07, 0x01, 0x06, 0x01, 0x06, 0x00, 0x00,
	0x0d, 0x12, 0x00, 0x09, 0x01, 0x09, 0x01, 0x0a, 0x02, 0x0a, 0x02, 0x0a, 0x03, 0x0b, 0x03, 0x0b,
	0x04, 0x0b, 0x05, 0x0c, 0x05, 0x0c, 0x06, 0x0c, 0x06, 0x0d, 0x07, 0x0d, 0x07, 0x0d, 0x06, 0x0c,
	0x06, 0x0c, 0x05, 0x0b, 0x05, 0x0b, 0x00, 0x00, 0x0e, 0x0e, 0x01, 0x07, 0x02, 0x0a, 0x02, 0x09,
	0x02, 0x09, 0x03, 0x08, 0x03, 0x08, 0x03, 0x07, 0x03, 0x07, 0x02, 0x08, 0x02, 0x08, 0x01, 0x09,
	0x01, 0x09, 0x02, 0x0b, 0x07, 0x0d, 0x00, 0x00, 0x11, 0x1f, 0x02, 0x05, 0x01, 0x06, 0x01, 0x06,
	0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x07,
	0x03, 0x07, 0x04, 0x07, 0x04, 0x07, 0x04, 0x09, 0x04, 0x0a, 0x04, 0x0b, 0x04, 0x0b, 0x05, 0x0b,
	0x05, 0x0b, 0x06, 0x0c, 0x06, 0x0c, 0x07, 0x0c, 0x08, 0x0d, 0x0a, 0x0f, 0x0b, 0x10, 0x0c, 0x11,
	0x0c, 0x11, 0x0c, 0x10, 0x0d, 0x10, 0x0d, 0x0f, 0x12, 0x1e, 0x02, 0x05, 0x01, 0x06, 0x01, 0x06,
	0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x07,
	0x03, 0x07, 0x04, 0x07, 0x04, 0x07, 0x04, 0x09, 0x04, 0x0b, 0x04, 0x0c, 0x05, 0x0c, 0x06, 0x0c,
	0x06, 0x0c, 0x07, 0x0d, 0x08, 0x0d, 0x09, 0x0d, 0x0b, 0x0f, 0x0c, 0x11, 0x0d, 0x12, 0x0d, 0x12,
	0x0d, 0x11, 0x0e, 0x11, 0x0e, 0x10, 0x00, 0x00, 0x0f, 0x1f, 0x01, 0x04, 0x01, 0x05, 0x00, 0x05,
	0x00, 0x06, 0x00, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x02, 0x06, 0x02, 0x06,
	0x02, 0x06, 0x03, 0x06, 0x03, 0x06, 0x03, 0x08, 0x03, 0x09, 0x03, 0x0a, 0x03, 0x0a, 0x04, 0x0a,
	0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x06, 0x0b, 0x07, 0x0c, 0x09, 0x0d, 0x0a, 0x0e, 0x0b, 0x0f,
	0x0b, 0x0f, 0x0b, 0x0e, 0x0b, 0x0e, 0x0b, 0x0d, 0x0d, 0x20, 0x02, 0x04, 0x01, 0x05, 0x01, 0x05,
	0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x05, 0x01, 0x05,
	0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x07, 0x02, 0x08, 0x02, 0x09, 0x02, 0x09, 0x03, 0x09,
	0x03, 0x09, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0a, 0x06, 0x0b, 0x07, 0x0b, 0x08, 0x0c, 0x09, 0x0d,
	0x09, 0x0d, 0x09, 0x0c, 0x09, 0x0c, 0x09, 0x0c, 0x09, 0x0b, 0x00, 0x00, 0x0b, 0x21, 0x02, 0x04,
	0x01, 0x05, 0x01, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06,
	0x01, 0x05, 0x01, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x06, 0x02, 0x07, 0x02, 0x08,
	0x02, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x04, 0x08, 0x04, 0x08, 0x05, 0x09,
	0x06, 0x09, 0x06, 0x0a, 0x07, 0x0a, 0x08, 0x0b, 0x08, 0x0b, 0x08, 0x0a, 0x07, 0x0a, 0x07, 0x09,
	0x08, 0x21, 0x02, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x00, 0x05,
	0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 0x01, 0x04, 0x01, 0x05,
	0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x01, 0x06, 0x02, 0x06,
	0x02, 0x06, 0x03, 0x06, 0x03, 0x07, 0x04, 0x07, 0x04, 0x08, 0x05, 0x08, 0x05, 0x08, 0x05, 0x08,
	0x04, 0x07, 0x04, 0x07, 0x07, 0x21, 0x02, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x06, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x04,
	0x01, 0x04, 0x01, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x00, 0x06, 0x00, 0x06, 0x01, 0x06,
	0x01, 0x06, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x02, 0x05, 0x02, 0x06, 0x03, 0x06, 0x03, 0x06,
	0x03, 0x06, 0x03, 0x06, 0x02, 0x05, 0x02, 0x05, 0x07, 0x21, 0x03, 0x05, 0x02, 0x06, 0x02, 0x06,
	0x01, 0x07, 0x01, 0x07, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x05, 0x01, 0x05,
	0x01, 0x05, 0x01, 0x04, 0x01, 0x04, 0x01, 0x05, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x00, 0x06,
	0x00, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x02, 0x05,
	0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x01, 0x04, 0x01, 0x04, 0x09, 0x21, 0x05, 0x07,
	0x04, 0x08, 0x04, 0x08, 0x03, 0x09, 0x03, 0x09, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08, 0x03, 0x08,
	0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x06, 0x02, 0x06, 0x02, 0x07, 0x01, 0x07, 0x01, 0x08,
	0x01, 0x08, 0x01, 0x08, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x06, 0x02, 0x06,
	0x02, 0x06, 0x02, 0x06, 0x02, 0x06, 0x02, 0x05, 0x02, 0x05, 0x02, 0x05, 0x01, 0x05, 0x01, 0x05,
	0x05, 0x09, 0x02, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x01, 0x04, 0x01, 0x03,
	0x01, 0x03, 0x00, 0x02, 0x01, 0x05, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
	0x06, 0x06, 0x01, 0x04, 0x00, 0x05, 0x00, 0x03, 0x00, 0x03, 0x00, 0x02, 0x01, 0x02, 0x00, 0x00,
	0x02, 0x05, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x02, 0x01, 0x02, 0x06, 0x05, 0x02, 0x05,
	0x01, 0x06, 0x03, 0x06, 0x03, 0x06, 0x04, 0x05, 0x04, 0x09, 0x00, 0x03, 0x00, 0x04, 0x00, 0x04,
	0x00, 0x04, 0x00, 0x04, 0x01, 0x04, 0x02, 0x04, 0x02, 0x04, 0x03, 0x04, 0x02, 0x05, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x00, 0x01, 0x00, 0x01, 0x01, 0x05, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x01, 0x00, 0x01, 0x04, 0x04, 0x01, 0x03, 0x00, 0x04, 0x01, 0x03, 0x01, 0x02, 0x00, 0x00,
	0x04, 0x04, 0x01, 0x03, 0x00, 0x04, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x06, 0x0d, 0x03, 0x03,
	0x02, 0x04, 0x01, 0x05, 0x01, 0x05, 0x01, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05, 0x00, 0x05,
	0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x00, 0x06, 0x06, 0x0d, 0x03, 0x03, 0x02, 0x04, 0x01, 0x05,
	0x01, 0x05, 0x01, 0x05, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x01, 0x06, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x06, 0x08, 0x0d, 0x02, 0x04, 0x02, 0x04, 0x01, 0x05, 0x01, 0x05, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x08, 0x01, 0x08, 0x02, 0x06, 0x02, 0x04,
	0x09, 0x0d, 0x03, 0x04, 0x02, 0x05, 0x02, 0x06, 0x01, 0x06, 0x01, 0x07, 0x00, 0x08, 0x00, 0x08,
	0x01, 0x08, 0x01, 0x09, 0x02, 0x09, 0x02, 0x09, 0x03, 0x07, 0x03, 0x05, 0x08, 0x0d, 0x04, 0x06,
	0x04, 0x06, 0x03, 0x07, 0x03, 0x07, 0x02, 0x08, 0x02, 0x08, 0x01, 0x08, 0x01, 0x08, 0x01, 0x07,
	0x00, 0x07, 0x00, 0x07, 0x02, 0x06, 0x04, 0x06, 0x09, 0x0d, 0x05, 0x06, 0x04, 0x07, 0x03, 0x07,
	0x03, 0x08, 0x02, 0x08, 0x01, 0x09, 0x01, 0x09, 0x01, 0x08, 0x00, 0x08, 0x00, 0x07, 0x00, 0x07,
	0x02, 0x06, 0x04, 0x06, 0x0a, 0x0e, 0x08, 0x0a, 0x08, 0x0a, 0x07, 0x09, 0x07, 0x09, 0x06, 0x08,
	0x06, 0x08, 0x05, 0x07, 0x05, 0x07, 0x04, 0x06, 0x02, 0x04, 0x01, 0x03, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x01, 0x00, 0x00, 0x0b, 0x0e, 0x09, 0x0b, 0x09, 0x0b, 0x08, 0x0a, 0x08, 0x0a, 0x07, 0x09,
	0x07, 0x09, 0x06, 0x08, 0x06, 0x08, 0x05, 0x07, 0x04, 0x06, 0x02, 0x04, 0x01, 0x03, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x00, 0x09, 0x0f, 0x07, 0x09, 0x07, 0x09, 0x06, 0x08, 0x06, 0x08, 0x06, 0x08,
	0x06, 0x08, 0x05, 0x07, 0x05, 0x07, 0x04, 0x06, 0x03, 0x05, 0x02, 0x04, 0x01, 0x03, 0x00, 0x02,
	0x00, 0x02, 0x01, 0x02, 0x07, 0x0f, 0x05, 0x07, 0x05, 0x07, 0x04, 0x06, 0x04, 0x06, 0x04, 0x06,
	0x04, 0x06, 0x03, 0x05, 0x03, 0x05, 0x02, 0x04, 0x02, 0x04, 0x01, 0x03, 0x01, 0x03, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x01, 0x05, 0x11, 0x03, 0x05, 0x03, 0x05, 0x03, 0x05, 0x03, 0x05, 0x02, 0x04,
	0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x02, 0x04, 0x01, 0x03, 0x01, 0x03, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x03, 0x11, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x03, 0x10, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x01, 0x00, 0x01, 0x00, 0x00,
	0x03, 0x10, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x00, 0x00, 0x03, 0x10, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x01, 0x03, 0x01, 0x03, 0x00, 0x00, 0x09, 0x03, 0x07, 0x09, 0x04, 0x09, 0x02, 0x09,
	0x07, 0x03, 0x00, 0x07, 0x02, 0x07, 0x04, 0x07, 0x06, 0x04, 0x00, 0x06, 0x02, 0x06, 0x03, 0x06,
	0x05, 0x06, 0x00, 0x00, 0x08, 0x03, 0x04, 0x07, 0x03, 0x07, 0x01, 0x05, 0x09, 0x03, 0x04, 0x07,
	0x01, 0x08, 0x04, 0x08, 0x07, 0x05, 0x04, 0x06, 0x04, 0x06, 0x03, 0x07, 0x02, 0x05, 0x01, 0x04,
	0x09, 0x03, 0x06, 0x08, 0x04, 0x08, 0x02, 0x09, 0x05, 0x07, 0x02, 0x04, 0x01, 0x05, 0x01, 0x04,
	0x01, 0x03, 0x01, 0x03, 0x00, 0x02, 0x00, 0x01, 0x0a, 0x0e, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x03, 0x05, 0x04, 0x06, 0x06, 0x08, 0x07, 0x09,
	0x08, 0x0a, 0x08, 0x0a, 0x09, 0x0a, 0x00, 0x00, 0x0b, 0x0e, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x03, 0x05, 0x04, 0x06, 0x05, 0x07, 0x07, 0x09,
	0x08, 0x0a, 0x09, 0x0b, 0x09, 0x0b, 0x00, 0x00, 0x09, 0x0f, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x04, 0x06, 0x05, 0x07,
	0x06, 0x08, 0x07, 0x09, 0x07, 0x09, 0x07, 0x08, 0x07, 0x0f, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x03, 0x05, 0x04, 0x06,
	0x04, 0x06, 0x05, 0x07, 0x05, 0x07, 0x06, 0x07, 0x05, 0x11, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x04, 0x02, 0x04,
	0x03, 0x05, 0x03, 0x05, 0x03, 0x05, 0x03, 0x05, 0x04, 0x05, 0x04, 0x05, 0x03, 0x11, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x02, 0x03,
	0x03, 0x10, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03,
	0x02, 0x03, 0x00, 0x00, 0x03, 0x10, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x01, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x03, 0x10, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x03,
	0x01, 0x03, 0x01, 0x03, 0x01, 0x03, 0x00, 0x02, 0x00, 0x02, 0x00, 0x00, 0x09, 0x03, 0x00, 0x02,
	0x00, 0x05, 0x00, 0x07, 0x07, 0x03, 0x00, 0x07, 0x00, 0x05, 0x00, 0x03, 0x06, 0x04, 0x00, 0x06,
	0x00, 0x04, 0x00, 0x03, 0x00, 0x01, 0x00, 0x00, 0x08, 0x03, 0x01, 0x04, 0x01, 0x05, 0x03, 0x07,
	0x09, 0x03, 0x02, 0x05, 0x01, 0x08, 0x01, 0x06, 0x07, 0x05, 0x01, 0x03, 0x01, 0x03, 0x00, 0x04,
	0x02, 0x05, 0x03, 0x06, 0x09, 0x03, 0x01, 0x03, 0x01, 0x05, 0x00, 0x07, 0x05, 0x07, 0x01, 0x03,
	0x00, 0x04, 0x01, 0x04, 0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x04, 0x05, 0x0e, 0x0c, 0x02, 0x0b,
	0x03, 0x0b, 0x04, 0x0a, 0x04, 0x0a, 0x05, 0x0b, 0x05, 0x0b, 0x05, 0x0b, 0x06, 0x0c, 0x06, 0x0c,
	0x04, 0x0c, 0x03, 0x0d, 0x01, 0x0d, 0x00, 0x00, 0x0e, 0x0f, 0x04, 0x07, 0x04, 0x09, 0x05, 0x0b,
	0x05, 0x0d, 0x05, 0x0c, 0x04, 0x0b, 0x04, 0x0a, 0x03, 0x09, 0x03, 0x09, 0x02, 0x08, 0x01, 0x08,
	0x01, 0x09, 0x03, 0x0a, 0x06, 0x0c, 0x08, 0x0d, 0x0e, 0x0c, 0x03, 0x0c, 0x03, 0x0b, 0x04, 0x0a,
	0x04, 0x0a, 0x03, 0x09, 0x03, 0x09, 0x03, 0x09, 0x02, 0x08, 0x02, 0x08, 0x02, 0x0a, 0x01, 0x0b,
	0x01, 0x0d, 0x00, 0x00, 0x0f, 0x12, 0x05, 0x0f, 0x05, 0x0e, 0x04, 0x0e, 0x04, 0x0d, 0x03, 0x0c,
	0x03, 0x0b, 0x02, 0x0b, 0x02, 0x0a, 0x01, 0x09, 0x01, 0x08, 0x01, 0x08, 0x00, 0x07, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x00, 0x07, 0x00, 0x00, 0x10, 0x0c, 0x06, 0x10,
	0x06, 0x0f, 0x07, 0x0e, 0x07, 0x0e, 0x07, 0x0d, 0x07, 0x0d, 0x06, 0x0d, 0x06, 0x0c, 0x06, 0x0c,
	0x04, 0x0c, 0x03, 0x0d, 0x01, 0x0d, 0x00, 0x00, 0x0f, 0x12, 0x00, 0x0a, 0x01, 0x0a, 0x01, 0x0b,
	0x02, 0x0b, 0x03, 0x0c, 0x04, 0x0c, 0x04, 0x0d, 0x05, 0x0d, 0x06, 0x0e, 0x07, 0x0e, 0x07, 0x0e,
	0x08, 0x0f, 0x09, 0x0f, 0x09, 0x0f, 0x09, 0x0f, 0x08, 0x0f, 0x08, 0x0f, 0x08, 0x0f, 0x00, 0x00,
	0x10, 0x0c, 0x00, 0x0a, 0x01, 0x0a, 0x02, 0x09, 0x02, 0x09, 0x03, 0x09, 0x03, 0x09, 0x03, 0x0a,
	0x04, 0x0a, 0x04, 0x0a, 0x04, 0x0c, 0x03, 0x0d, 0x03, 0x0f, 0x00, 0x00, 0x0b, 0x0a, 0x05, 0x0b,
	0x05, 0x0b, 0x06, 0x0b, 0x03, 0x0b, 0x00, 0x0b, 0x00, 0x0b, 0x01, 0x0b, 0x01, 0x0b, 0x01, 0x0b,
	0x02, 0x0b, 0x00, 0x00, 0x11, 0x0c, 0x06, 0x10, 0x02, 0x10, 0x00, 0x11, 0x00, 0x11, 0x01, 0x10,
	0x01, 0x10, 0x01, 0x0f, 0x02, 0x0f, 0x04, 0x0e, 0x06, 0x0d, 0x06, 0x0c, 0x05, 0x0c, 0x00, 0x00,
	0x10, 0x0e, 0x0a, 0x0b, 0x09, 0x0b, 0x06, 0x0c, 0x02, 0x0c, 0x00, 0x0c, 0x01, 0x0d, 0x01, 0x0e,
	0x02, 0x0e, 0x02, 0x0f, 0x04, 0x09, 0x05, 0x0a, 0x06, 0x0a, 0x06, 0x0b, 0x07, 0x0b, 0x00, 0x00,
	0x11, 0x1c, 0x0a, 0x0b, 0x08, 0x0d, 0x07, 0x0f, 0x06, 0x0f, 0x06, 0x10, 0x05, 0x10, 0x04, 0x11,
	0x04, 0x11, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x10, 0x04, 0x0f, 0x04, 0x0f, 0x04, 0x0e,
	0x03, 0x0e, 0x03, 0x0d, 0x02, 0x0d, 0x02, 0x0c, 0x02, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c,
	0x00, 0x0c, 0x00, 0x0c, 0x01, 0x0a, 0x01, 0x08, 0x02, 0x06, 0x00, 0x00, 0x11, 0x1c, 0x0a, 0x0b,
	0x08, 0x0d, 0x07, 0x0e, 0x06, 0x0f, 0x06, 0x0f, 0x05, 0x10, 0x04, 0x11, 0x04, 0x11, 0x04, 0x10,
	0x04, 0x10, 0x04, 0x10, 0x04, 0x0f, 0x04, 0x0f, 0x04, 0x0f, 0x03, 0x0e, 0x03, 0x0e, 0x02, 0x0d,
	0x02, 0x0d, 0x01, 0x0c, 0x01, 0x0c, 0x01, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x0c, 0x01, 0x0a,
	0x01, 0x09, 0x02, 0x08, 0x02, 0x06, 0x00, 0x00, 0x11, 0x0c, 0x06, 0x10, 0x02, 0x10, 0x00, 0x11,
	0x00, 0x11, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10, 0x02, 0x0f, 0x04, 0x0f, 0x07, 0x0e, 0x07, 0x0e,
	0x06, 0x0d, 0x00, 0x00, 0x17, 0x06, 0x09, 0x17, 0x04, 0x17, 0x01, 0x17, 0x01, 0x16, 0x00, 0x15,
	0x05, 0x0f, 0x00, 0x00, 0x08, 0x05, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x01, 0x07, 0x01, 0x07,
	0x18, 0x07, 0x0a, 0x0f, 0x04, 0x11, 0x01, 0x15, 0x03, 0x18, 0x05, 0x18, 0x07, 0x17, 0x09, 0x17,
	0x0e, 0x06, 0x06, 0x0d, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x06, 0x0e, 0x00, 0x00,
	0x10, 0x07, 0x02, 0x09, 0x01, 0x0d, 0x00, 0x10, 0x00, 0x10, 0x01, 0x10, 0x01, 0x0e, 0x03, 0x08,
	0x13, 0x06, 0x03, 0x0a, 0x01, 0x0f, 0x00, 0x12, 0x01, 0x12, 0x01, 0x13, 0x04, 0x0f, 0x00, 0x00,
	0x0f, 0x07, 0x01, 0x08, 0x01, 0x0c, 0x00, 0x0f, 0x00, 0x0f, 0x01, 0x0f, 0x02, 0x0d, 0x04, 0x09,
	0x12, 0x07, 0x03, 0x08, 0x01, 0x0e, 0x00, 0x12, 0x00, 0x11, 0x01, 0x0f, 0x02, 0x0c, 0x03, 0x09,
	0x08, 0x11, 0x01, 0x05, 0x01, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x07,
	0x01, 0x07, 0x02, 0x07, 0x02, 0x07, 0x02, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07, 0x03, 0x07,
	0x04, 0x08, 0x04, 0x08, 0x10, 0x07, 0x02, 0x06, 0x01, 0x0c, 0x00, 0x10, 0x00, 0x0f, 0x00, 0x0d,
	0x01, 0x0a, 0x01, 0x07, 0x10, 0x0e, 0x05, 0x06, 0x05, 0x07, 0x04, 0x0a, 0x04, 0x0e, 0x04, 0x10,
	0x03, 0x0f, 0x02, 0x0f, 0x02, 0x0e, 0x01, 0x0e, 0x07, 0x0c, 0x06, 0x0b, 0x06, 0x0a, 0x05, 0x0a,
	0x05, 0x09, 0x00, 0x00, 0x11, 0x1c, 0x06, 0x07, 0x04, 0x09, 0x02, 0x0a, 0x02, 0x0b, 0x01, 0x0b,
	0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x02, 0x0d,
	0x02, 0x0d, 0x03, 0x0d, 0x03, 0x0e, 0x04, 0x0e, 0x04, 0x0f, 0x05, 0x0f, 0x05, 0x0f, 0x05, 0x10,
	0x05, 0x10, 0x05, 0x10, 0x05, 0x11, 0x05, 0x11, 0x07, 0x10, 0x09, 0x10, 0x0b, 0x0f, 0x00, 0x00,
	0x11, 0x0c, 0x01, 0x0b, 0x01, 0x0f, 0x00, 0x11, 0x00, 0x11, 0x01, 0x10, 0x01, 0x10, 0x02, 0x10,
	0x02, 0x0f, 0x03, 0x0d, 0x04, 0x0b, 0x05, 0x0b, 0x05, 0x0c, 0x00, 0x00, 0x0b, 0x0a, 0x00, 0x06,
	0x00, 0x06, 0x00, 0x05, 0x00, 0x08, 0x00, 0x0b, 0x00, 0x0b, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a,
	0x00, 0x09, 0x00, 0x00, 0x11, 0x1c, 0x06, 0x07, 0x04, 0x09, 0x03, 0x0a, 0x02, 0x0b, 0x02, 0x0b,
	0x01, 0x0c, 0x00, 0x0d, 0x00, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x01, 0x0d, 0x02, 0x0d, 0x02, 0x0d,
	0x02, 0x0d, 0x03, 0x0e, 0x03, 0x0e, 0x04, 0x0f, 0x04, 0x0f, 0x05, 0x10, 0x05, 0x10, 0x05, 0x10,
	0x05, 0x11, 0x05, 0x11, 0x05, 0x11, 0x07, 0x10, 0x08, 0x10, 0x09, 0x0f, 0x0b, 0x0f, 0x00, 0x00,
	0x11, 0x0c, 0x01, 0x0b, 0x01, 0x0f, 0x00, 0x11, 0x00, 0x11, 0x01, 0x10, 0x01, 0x10, 0x01, 0x10,
	0x02, 0x0f, 0x02, 0x0d, 0x03, 0x0a, 0x03, 0x0a, 0x04, 0x0b, 0x00, 0x00, 0x0a, 0x0d, 0x03, 0x07,
	0x01, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09, 0x01, 0x09,
	0x01, 0x09, 0x02, 0x08, 0x02, 0x08, 0x02, 0x08, 0x0e, 0x03, 0x06, 0x0c, 0x00, 0x0c, 0x00, 0x07,
	0x11, 0x02, 0x00, 0x0f, 0x01, 0x09, 0x00, 0x00, 0x13, 0x03, 0x0c, 0x11, 0x07, 0x0d, 0x03, 0x09,
	0x11, 0x02, 0x02, 0x11, 0x08, 0x10, 0x00, 0x00, 0x13, 0x03, 0x02, 0x07, 0x06, 0x0c, 0x0a, 0x10,
	0x10, 0x06, 0x02, 0x0e, 0x03, 0x09, 0x04, 0x05, 0x03, 0x04, 0x02, 0x04, 0x01, 0x03, 0x00, 0x00,
	0x0e, 0x08, 0x0b, 0x0d, 0x08, 0x0b, 0x05, 0x09, 0x02, 0x07, 0x05, 0x06, 0x05, 0x06, 0x05, 0x06,
	0x05, 0x07, 0x00, 0x00, 0x10, 0x06, 0x02, 0x0e, 0x07, 0x0d, 0x0b, 0x0c, 0x0c, 0x0d, 0x0c, 0x0e,
	0x0d, 0x0f, 0x00, 0x00, 0x0e, 0x08, 0x01, 0x03, 0x03, 0x06, 0x05, 0x09, 0x07, 0x0c, 0x08, 0x09,
	0x08, 0x09, 0x08, 0x09, 0x07, 0x09, 0x00, 0x00, 0x11, 0x02, 0x02, 0x11, 0x01, 0x11, 0x00, 0x00,
	0x09, 0x0b, 0x06, 0x07, 0x05, 0x08, 0x04, 0x09, 0x03, 0x09, 0x03, 0x09, 0x02, 0x08, 0x01, 0x08,
	0x01, 0x08, 0x01, 0x07, 0x00, 0x07, 0x00, 0x06, 0x10, 0x03, 0x02, 0x0a, 0x01, 0x10, 0x08, 0x10,
	0x09, 0x0b, 0x02, 0x03, 0x01, 0x04, 0x00, 0x05, 0x00, 0x06, 0x00, 0x06, 0x01, 0x07, 0x01, 0x08,
	0x01, 0x08, 0x02, 0x08, 0x02, 0x09, 0x03, 0x09, 0x11, 0x02, 0x00, 0x0f, 0x00, 0x10, 0x00, 0x00,
	0x04, 0x08, 0x02, 0x04, 0x02, 0x04, 0x02, 0x03, 0x01, 0x03, 0x01, 0x03, 0x01, 0x02, 0x01, 0x02,
	0x00, 0x01, 0x00, 0x00, 0x03, 0x09, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x01, 0x02, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x08, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x05, 0x09, 0x04, 0x05,
	0x04, 0x05, 0x03, 0x04, 0x03, 0x04, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02, 0x01, 0x02, 0x00, 0x01,
	0x04, 0x08, 0x00, 0x02, 0x00, 0x02, 0x01, 0x02, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x02, 0x03,
	0x03, 0x04, 0x00, 0x00, 0x03, 0x09, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x00, 0x01, 0x00, 0x01, 0x02, 0x08, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x00, 0x02, 0x00, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x00, 0x00, 0x07, 0x08, 0x06, 0x07,
	0x05, 0x06, 0x05, 0x06, 0x04, 0x05, 0x03, 0x05, 0x02, 0x04, 0x02, 0x03, 0x01, 0x03, 0x00, 0x00,
	0x07, 0x09, 0x07, 0x07, 0x07, 0x07, 0x06, 0x06, 0x06, 0x06, 0x05, 0x06, 0x05, 0x05, 0x02, 0x05,
	0x00, 0x05, 0x00, 0x03, 0x08, 0x05, 0x03, 0x08, 0x02, 0x08, 0x02, 0x08, 0x01, 0x07, 0x01, 0x07,
	0x05, 0x0b, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x05, 0x04, 0x05,
	0x04, 0x05, 0x03, 0x05, 0x02, 0x05, 0x01, 0x04, 0x04, 0x0b, 0x01, 0x01, 0x01, 0x01, 0x01, 0x02,
	0x02, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x03, 0x03, 0x04, 0x00, 0x03, 0x00, 0x03,
	0x03, 0x0a, 0x03, 0x03, 0x03, 0x03, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02, 0x02, 0x02, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x01, 0x00, 0x01, 0x00, 0x00, 0x03, 0x08, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
	0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x00, 0x00, 0x04, 0x0a, 0x00, 0x01,
	0x00, 0x01, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03,
	0x03, 0x04, 0x00, 0x00, 0x05, 0x09, 0x00, 0x01, 0x00, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x03,
	0x02, 0x03, 0x03, 0x04, 0x03, 0x04, 0x04, 0x05, 0x06, 0x07, 0x00, 0x02, 0x01, 0x03, 0x01, 0x03,
	0x02, 0x04, 0x03, 0x04, 0x04, 0x05, 0x04, 0x05, 0x06, 0x07, 0x00, 0x02, 0x01, 0x03, 0x01, 0x03,
	0x02, 0x04, 0x02, 0x04, 0x03, 0x05, 0x03, 0x05, 0x04, 0x07, 0x00, 0x02, 0x00, 0x02, 0x01, 0x03,
	0x01, 0x03, 0x02, 0x03, 0x02, 0x03, 0x03, 0x04, 0x03, 0x08, 0x00, 0x02, 0x00, 0x02, 0x00, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x01, 0x03, 0x01, 0x03, 0x02, 0x03, 0x00, 0x00, 0x08, 0x09, 0x00, 0x00,
	0x00, 0x01, 0x01, 0x01, 0x01, 0x02, 0x02, 0x03, 0x02, 0x03, 0x03, 0x08, 0x03, 0x07, 0x04, 0x06,
	0x01, 0x09, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01, 0x00, 0x01,
	0x00, 0x01, 0x00, 0x01, 0x03, 0x08, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x00, 0x01, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01,
	0x01, 0x01, 0x01, 0x01, 0x01, 0x02, 0x01, 0x02, 0x02, 0x02, 0x02, 0x03, 0x02, 0x03, 0x02, 0x04,
	0x04, 0x0a, 0x03, 0x04, 0x03, 0x04, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x00, 0x01, 0x00, 0x00, 0x05, 0x0b, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
	0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x03, 0x01, 0x04,
	0x05, 0x09, 0x04, 0x05, 0x04, 0x05, 0x03, 0x04, 0x03, 0x04, 0x02, 0x03, 0x02, 0x03, 0x01, 0x02,
	0x01, 0x02, 0x00, 0x01, 0x04, 0x0b, 0x03, 0x03, 0x03, 0x03, 0x02, 0x03, 0x02, 0x02, 0x02, 0x02,
	0x01, 0x02, 0x01, 0x02, 0x01, 0x01, 0x00, 0x01, 0x01, 0x04, 0x01, 0x04, 0x09, 0x11, 0x01, 0x05,
	0x01, 0x06, 0x00, 0x06, 0x00, 0x07, 0x00, 0x07, 0x01, 0x07, 0x01, 0x07, 0x02, 0x07, 0x02, 0x08,
	0x03, 0x08, 0x03, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x04, 0x08, 0x05, 0x09, 0x05, 0x09,
	0x0e, 0x06, 0x01, 0x08, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x08, 0x00, 0x00,
	0x0a, 0x0a, 0x03, 0x09, 0x01, 0x09, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a, 0x00, 0x0a,
	0x01, 0x0a, 0x03, 0x0a, 0x04, 0x09, 0x00, 0x00, 0x06, 0x04, 0x03, 0x06, 0x02, 0x05, 0x02, 0x03,
	0x01, 0x02, 0x00, 0x00, 0x06, 0x04, 0x00, 0x03, 0x01, 0x04, 0x03, 0x04, 0x04, 0x05, 0x00, 0x00
};

const uint8_t *Video::_vertices3DO[201] = {
	&_verticesData3DO[0],
	&_verticesData3DO[36],
	&_verticesData3DO[84],
	&_verticesData3DO[112],
	&_verticesData3DO[144],
	&_verticesData3DO[208],
	&_verticesData3DO[244],
	&_verticesData3DO[296],
	&_verticesData3DO[328],
	&_verticesData3DO[368],
	&_verticesData3DO[412],
	&_verticesData3DO[444],
	&_verticesData3DO[476],
	&_verticesData3DO[540],
	&_verticesData3DO[584],
	&_verticesData3DO[628],
	&_verticesData3DO[660],
	&_verticesData3DO[688],
	&_verticesData3DO[728],
	&_verticesData3DO[768],
	&_verticesData3DO[804],
	&_verticesData3DO[844],
	&_verticesData3DO[872],
	&_verticesData3DO[936],
	&_verticesData3DO[976],
	&_verticesData3DO[1020],
	&_verticesData3DO[1060],
	&_verticesData3DO[1100],
	&_verticesData3DO[1132],
	&_verticesData3DO[1196],
	&_verticesData3DO[1260],
	&_verticesData3DO[1324],
	&_verticesData3DO[1392],
	&_verticesData3DO[1460],
	&_verticesData3DO[1528],
	&_verticesData3DO[1596],
	&_verticesData3DO[1664],
	&_verticesData3DO[1732],
	&_verticesData3DO[1760],
	&_verticesData3DO[1808],
	&_verticesData3DO[1844],
	&_verticesData3DO[1876],
	&_verticesData3DO[1940],
	&_verticesData3DO[1976],
	&_verticesData3DO[2028],
	&_verticesData3DO[2052],
	&_verticesData3DO[2084],
	&_verticesData3DO[2124],
	&_verticesData3DO[2168],
	&_verticesData3DO[2200],
	&_verticesData3DO[2232],
	&_verticesData3DO[2276],
	&_verticesData3DO[2320],
	&_verticesData3DO[2348],
	&_verticesData3DO[2388],
	&_verticesData3DO[2428],
	&_verticesData3DO[2464],
	&_verticesData3DO[2528],
	&_verticesData3DO[2568],
	&_verticesData3DO[2596],
	&_verticesData3DO[2660],
	&_verticesData3DO[2700],
	&_verticesData3DO[2744],
	&_verticesData3DO[2784],
	&_verticesData3DO[2824],
	&_verticesData3DO[2856],
	&_verticesData3DO[2920],
	&_verticesData3DO[2984],
	&_verticesData3DO[3048],
	&_verticesData3DO[3116],
	&_verticesData3DO[3184],
	&_verticesData3DO[3252],
	&_verticesData3DO[3320],
	&_verticesData3DO[3388],
	&_verticesData3DO[3456],
	&_verticesData3DO[3476],
	&_verticesData3DO[3488],
	&_verticesData3DO[3504],
	&_verticesData3DO[3516],
	&_verticesData3DO[3528],
	&_verticesData3DO[3548],
	&_verticesData3DO[3560],
	&_verticesData3DO[3572],
	&_verticesData3DO[3584],
	&_verticesData3DO[3596],
	&_verticesData3DO[3624],
	&_verticesData3DO[3652],
	&_verticesData3DO[3680],
	&_verticesData3DO[3708],
	&_verticesData3DO[3736],
	&_verticesData3DO[3764],
	&_verticesData3DO[3796],
	&_verticesData3DO[3828],
	&_verticesData3DO[3860],
	&_verticesData3DO[3892],
	&_verticesData3DO[3928],
	&_verticesData3DO[3964],
	&_verticesData3DO[4000],
	&_verticesData3DO[4036],
	&_verticesData3DO[4072],
	&_verticesData3DO[4080],
	&_verticesData3DO[4088],
	&_verticesData3DO[4100],
	&_verticesData3DO[4108],
	&_verticesData3DO[4116],
	&_verticesData3DO[4128],
	&_verticesData3DO[4136],
	&_verticesData3DO[4152],
	&_verticesData3DO[4184],
	&_verticesData3DO[4216],
	&_verticesData3DO[4248],
	&_verticesData3DO[4280],
	&_verticesData3DO[4316],
	&_verticesData3DO[4352],
	&_verticesData3DO[4388],
	&_verticesData3DO[4424],
	&_verticesData3DO[4460],
	&_verticesData3DO[4468],
	&_verticesData3DO[4476],
	&_verticesData3DO[4488],
	&_verticesData3DO[4496],
	&_verticesData3DO[4504],
	&_verticesData3DO[4516],
	&_verticesData3DO[4524],
	&_verticesData3DO[4540],
	&_verticesData3DO[4568],
	&_verticesData3DO[4600],
	&_verticesData3DO[4628],
	&_verticesData3DO[4668],
	&_verticesData3DO[4696],
	&_verticesData3DO[4736],
	&_verticesData3DO[4764],
	&_verticesData3DO[4788],
	&_verticesData3DO[4816],
	&_verticesData3DO[4848],
	&_verticesData3DO[4908],
	&_verticesData3DO[4968],
	&_verticesData3DO[4996],
	&_verticesData3DO[5012],
	&_verticesData3DO[5024],
	&_verticesData3DO[5040],
	&_verticesData3DO[5056],
	&_verticesData3DO[5072],
	&_verticesData3DO[5088],
	&_verticesData3DO[5104],
	&_verticesData3DO[5120],
	&_verticesData3DO[5156],
	&_verticesData3DO[5172],
	&_verticesData3DO[5204],
	&_verticesData3DO[5264],
	&_verticesData3DO[5292],
	&_verticesData3DO[5316],
	&_verticesData3DO[5376],
	&_verticesData3DO[5404],
	&_verticesData3DO[5432],
	&_verticesData3DO[5440],
	&_verticesData3DO[5448],
	&_verticesData3DO[5456],
	&_verticesData3DO[5464],
	&_verticesData3DO[5472],
	&_verticesData3DO[5488],
	&_verticesData3DO[5508],
	&_verticesData3DO[5524],
	&_verticesData3DO[5544],
	&_verticesData3DO[5552],
	&_verticesData3DO[5576],
	&_verticesData3DO[5584],
	&_verticesData3DO[5608],
	&_verticesData3DO[5616],
	&_verticesData3DO[5636],
	&_verticesData3DO[5656],
	&_verticesData3DO[5676],
	&_verticesData3DO[5696],
	&_verticesData3DO[5716],
	&_verticesData3DO[5736],
	&_verticesData3DO[5756],
	&_verticesData3DO[5776],
	&_verticesData3DO[5796],
	&_verticesData3DO[5808],
	&_verticesData3DO[5832],
	&_verticesData3DO[5856],
	&_verticesData3DO[5880],
	&_verticesData3DO[5900],
	&_verticesData3DO[5924],
	&_verticesData3DO[5944],
	&_verticesData3DO[5960],
	&_verticesData3DO[5976],
	&_verticesData3DO[5992],
	&_verticesData3DO[6012],
	&_verticesData3DO[6032],
	&_verticesData3DO[6052],
	&_verticesData3DO[6072],
	&_verticesData3DO[6096],
	&_verticesData3DO[6120],
	&_verticesData3DO[6144],
	&_verticesData3DO[6164],
	&_verticesData3DO[6188],
	&_verticesData3DO[6224],
	&_verticesData3DO[6240],
	&_verticesData3DO[6264],
	&_verticesData3DO[6276],
};

const uint16_t Graphics::_shapesMaskOffset[] = {
	0x0000, 0x0022, 0x0052, 0x006c, 0x008c, 0x00ca, 0x0110, 0x0142,
	0x0180, 0x01a8, 0x01fe, 0x021c, 0x025a, 0x0298, 0x02c2, 0x0314,
	0x0334, 0x034e, 0x0376, 0x039e, 0x03c0, 0x03e8, 0x0402, 0x0440,
	0x0466, 0x0492, 0x04b8, 0x04de, 0x04fc, 0x057a, 0x05f4, 0x0634,
	0x0676, 0x06ba, 0x06fe, 0x0742, 0x0786, 0x07ca, 0x07e4, 0x0814,
	0x0836, 0x0856, 0x0894, 0x08da, 0x1c2a, 0x090c, 0x094a, 0x0972,
	0x09c8, 0x09e6, 0x0a24, 0x0a4e, 0x0ac0, 0x0ada, 0x0b02, 0x0b2a,
	0x0b4c, 0x0b8a, 0x0bb2, 0x0bcc, 0x0c0a, 0x0c30, 0x0c5c, 0x0c82,
	0x0ca8, 0x0cc6, 0x0d44, 0x0dbe, 0x0dfe, 0x0e40, 0x0e84, 0x0ec8,
	0x0f0c, 0x0f50, 0x0f94, 0x0fa8, 0x0fb4, 0x0fc2, 0x0fce, 0x0fda,
	0x0fee, 0x0ffa, 0x10ae, 0x10b8, 0x1076, 0x1092, 0x1006, 0x103e,
	0x1022, 0x105a, 0x10c2, 0x10e0, 0x10fe, 0x111e, 0x113e, 0x1162,
	0x1186, 0x11a8, 0x11ca, 0x11ec, 0x11f4, 0x11fc, 0x1206, 0x120e,
	0x1216, 0x1222, 0x122a, 0x123a, 0x1258, 0x1276, 0x1296, 0x12b6,
	0x12da, 0x12fe, 0x1320, 0x1342, 0x1364, 0x136c, 0x1374, 0x137e,
	0x1386, 0x138e, 0x139a, 0x13a2, 0x13b2, 0x0aa0, 0x13cc, 0x13e6,
	0x140c, 0x143e, 0x1464, 0x1496, 0x14ac, 0x14de, 0x1518, 0x158a,
	0x15fc, 0x162e, 0x1648, 0x1654, 0x1672, 0x1680, 0x169e, 0x16b8,
	0x16c8, 0x1724, 0x1748, 0x1766, 0x17a0, 0x1812, 0x1844, 0x185a,
	0x18cc, 0x18fe, 0x191a, 0x1930, 0x1922, 0x1948, 0x193a, 0x1964,
	0x1952, 0x1990, 0x197e, 0x19c2, 0x19aa, 0x19cc, 0x19da, 0x19f2,
	0x19fc, 0x1a0e, 0x1a22, 0x1a5a, 0x1a34, 0x1a46, 0x1a80, 0x1a6e,
	0x1a92, 0x16e6, 0x1ace, 0x1afc, 0x1aa6, 0x1abc, 0x1ae6, 0x1b14,
	0x1b28, 0x1b60, 0x1b9a, 0x1bc0, 0x1b38, 0x1b4c, 0x1b70, 0x1b82,
	0x1baa, 0x1bfe, 0x1bd2, 0x1be6, 0x16f2, 0x1716, 0x1c40, 0x1c20,
	0x1c16
};

const int Graphics::_shapesMaskCount = ARRAYSIZE(_shapesMaskOffset);

const uint8_t Graphics::_shapesMaskData[] = {
	0x0f, 0x10, 0x07, 0xff, 0x07, 0xfe, 0x0f, 0xfe, 0x0f, 0xfc, 0x1f, 0xf8, 0x1f, 0xf0, 0x3f, 0xf0,
	0x3f, 0xe0, 0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0xfc, 0x00, 0x0b, 0x17, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00,
	0x3f, 0x00, 0x3f, 0x00, 0x1f, 0x80, 0x1f, 0xc0, 0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xe0, 0x07, 0xf0,
	0x03, 0xf0, 0x0e, 0x0c, 0x1f, 0xf0, 0x0f, 0xf0, 0x07, 0xe0, 0x07, 0xe0, 0x07, 0xf0, 0x07, 0xf0,
	0x03, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x0f, 0xf8, 0x1f, 0xfc, 0x7f, 0xfc, 0x0f, 0x0f, 0x01, 0xc0,
	0x01, 0xf0, 0x00, 0xfc, 0x00, 0xff, 0x00, 0xfe, 0x00, 0xfe, 0x01, 0xfc, 0x03, 0xf8, 0x3f, 0xf8,
	0xff, 0xf0, 0x3f, 0xf0, 0x0f, 0xf0, 0x03, 0xf0, 0x00, 0xf0, 0x00, 0x30, 0x0d, 0x1e, 0x03, 0x80,
	0x0f, 0xc0, 0x1f, 0xc0, 0x3f, 0xe0, 0x3f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc,
	0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8,
	0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0xff, 0xf8,
	0xff, 0xf8, 0xff, 0xf8, 0xff, 0xf8, 0x3f, 0xf8, 0x01, 0xf0, 0x10, 0x11, 0x03, 0xff, 0x80, 0x00,
	0x07, 0xff, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00,
	0x1f, 0xf8, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00,
	0x7f, 0xc0, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00,
	0x0b, 0x18, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x00,
	0x3f, 0x00, 0x1f, 0x80, 0x1f, 0xc0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0, 0x03, 0xf0, 0x03, 0xf0,
	0x01, 0xf0, 0x10, 0x0f, 0x01, 0x80, 0x00, 0x00, 0x01, 0xe0, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00,
	0x00, 0xfc, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x80, 0x00, 0x01, 0xfe, 0x00, 0x00,
	0x01, 0xfc, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00,
	0x07, 0xf8, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0x30, 0x00, 0x00,
	0x0e, 0x13, 0x0f, 0xfe, 0x0f, 0xfc, 0x1f, 0xfc, 0x1f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf0, 0x7f, 0xe0,
	0x7f, 0xe0, 0xff, 0xc0, 0xff, 0x80, 0xff, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x10, 0x15, 0xff, 0x80, 0x00, 0x00, 0xff, 0x80,
	0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x3f, 0xc0,
	0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x1f, 0xc0,
	0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xe0,
	0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00, 0x01, 0xf8,
	0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x0f, 0x0e,
	0x7f, 0xf0, 0x1f, 0xf0, 0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x03, 0xf8,
	0x03, 0xf8, 0x07, 0xfc, 0x07, 0xfc, 0x0f, 0xfe, 0x1f, 0xf8, 0x7e, 0x00, 0x11, 0x0f, 0x00, 0xc0,
	0x00, 0x00, 0x00, 0xf0, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7f,
	0x80, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00, 0x01, 0xfc,
	0x00, 0x00, 0x07, 0xfc, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x0d, 0x1e, 0x07, 0x80, 0x0f, 0xc0,
	0x1f, 0xc0, 0x3f, 0xe0, 0x3f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc,
	0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8,
	0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf8, 0x7f, 0xf8, 0xff, 0xf8, 0xff, 0xf8,
	0xff, 0xfc, 0xff, 0xfc, 0x1f, 0xfc, 0x00, 0x7c, 0x0d, 0x14, 0x0f, 0xfc, 0x0f, 0xfc, 0x1f, 0xf8,
	0x1f, 0xf8, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xe0, 0x3f, 0xc0, 0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0x00,
	0xff, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00,
	0x7e, 0x00, 0x12, 0x14, 0xff, 0x80, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00,
	0x7f, 0xc0, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00,
	0x3f, 0xc0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00,
	0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x00,
	0x07, 0xf0, 0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00,
	0x00, 0x7f, 0xc0, 0x00, 0x0e, 0x0f, 0x01, 0xe0, 0x07, 0xe0, 0x1f, 0xc0, 0x7f, 0xc0, 0x3f, 0xc0,
	0x1f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0, 0x03, 0xf8, 0x03, 0xfc, 0x07, 0xfc, 0x0f, 0xf0,
	0x3f, 0x80, 0x7e, 0x00, 0x0f, 0x0c, 0x03, 0xff, 0x03, 0xfe, 0x01, 0xfc, 0x01, 0xfc, 0x01, 0xfc,
	0x01, 0xfc, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x0f, 0xf8, 0x1f, 0xfc, 0x7f, 0xfc, 0x0c, 0x13,
	0x3f, 0xf8, 0x3f, 0xf0, 0x3f, 0xf0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0x80,
	0xff, 0x00, 0xff, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00, 0x0b, 0x13, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xff, 0x80, 0x7f, 0xf0, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 0x10,
	0x03, 0xc0, 0x07, 0xc0, 0x1f, 0xe0, 0x3f, 0xe0, 0x7f, 0xf0, 0x7f, 0xf0, 0x1f, 0xf8, 0x07, 0xfc,
	0x01, 0xfe, 0x00, 0xff, 0x01, 0xfe, 0x01, 0xf8, 0x03, 0xf0, 0x03, 0xe0, 0x07, 0x80, 0x07, 0x00,
	0x0a, 0x13, 0x3f, 0xe0, 0x3f, 0xe0, 0x3f, 0xc0, 0x7f, 0xc0, 0x7f, 0xc0, 0x7f, 0xc0, 0x7f, 0x80,
	0x7f, 0x80, 0xff, 0x80, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x0e, 0x0c, 0x07, 0xfe, 0x07, 0xfc, 0x03, 0xf8,
	0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x0f, 0xf8, 0x1f, 0xfc,
	0x7f, 0xfc, 0x0d, 0x1e, 0x01, 0x80, 0x07, 0xc0, 0x1f, 0xc0, 0x3f, 0xe0, 0x3f, 0xf0, 0x7f, 0xf0,
	0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8,
	0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xe0, 0x7f, 0xe0, 0x7f, 0xe0,
	0x7f, 0xf0, 0x7f, 0xf0, 0xff, 0xf0, 0xff, 0xf8, 0xff, 0xf8, 0x3f, 0xf0, 0x0f, 0xf0, 0x03, 0xe0,
	0x07, 0x12, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x3f, 0x00, 0x0d, 0x15, 0x07, 0xfc, 0x07, 0xf8, 0x0f, 0xf8, 0x0f, 0xf0,
	0x1f, 0xf0, 0x1f, 0xe0, 0x1f, 0xe0, 0x3f, 0xc0, 0x3f, 0xc0, 0x3f, 0x80, 0x7f, 0x80, 0x7f, 0x00,
	0xff, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x3f, 0xc0, 0x1f, 0xe0, 0x0f, 0xf0, 0x07, 0xf8, 0x07, 0xf8,
	0x03, 0xf0, 0x08, 0x12, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x0d, 0x12, 0x0f, 0xfc, 0x0f, 0xf8, 0x1f, 0xf8,
	0x1f, 0xf0, 0x1f, 0xf0, 0x3f, 0xe0, 0x3f, 0xe0, 0x3f, 0xc0, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x00,
	0xff, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x80, 0x3f, 0x80, 0x0e, 0x0e,
	0x01, 0xfc, 0x0f, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf0, 0x03, 0xf0, 0x01, 0xf0, 0x01, 0xf0,
	0x03, 0xf8, 0x03, 0xf8, 0x07, 0xfc, 0x07, 0xfc, 0x1f, 0xf8, 0x7f, 0x00, 0x11, 0x1f, 0x00, 0x0f,
	0x00, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x3f,
	0xc0, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f,
	0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x3c,
	0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x03, 0xfc,
	0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x07, 0xf0,
	0x00, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x3f, 0x00,
	0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x7c, 0x00,
	0x00, 0x00, 0x78, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x12, 0x1e, 0x00, 0x07, 0x80, 0x00,
	0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x1f, 0xe0, 0x00,
	0x00, 0x1f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x1f, 0x80, 0x00,
	0x00, 0x1f, 0x80, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x1e, 0x00, 0x00,
	0x00, 0x1e, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x03, 0xfe, 0x00, 0x00,
	0x03, 0xfc, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x00,
	0x07, 0xe0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x7c, 0x00, 0x00, 0x00, 0x78, 0x00, 0x00, 0x00,
	0x38, 0x00, 0x00, 0x00, 0x0f, 0x1f, 0x00, 0x1e, 0x00, 0x3e, 0x00, 0x3f, 0x00, 0x7f, 0x00, 0x7f,
	0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x78,
	0x00, 0x78, 0x01, 0xf8, 0x03, 0xf8, 0x07, 0xf8, 0x07, 0xf8, 0x07, 0xf0, 0x07, 0xf0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xc0, 0x1f, 0x80, 0x3e, 0x00, 0x7c, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x78, 0x00,
	0x78, 0x00, 0x38, 0x00, 0x0d, 0x20, 0x00, 0x70, 0x00, 0xf8, 0x00, 0xf8, 0x01, 0xfc, 0x01, 0xfc,
	0x01, 0xfc, 0x01, 0xf8, 0x01, 0xf8, 0x01, 0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xf0,
	0x00, 0xf0, 0x03, 0xf0, 0x07, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0,
	0x1f, 0xc0, 0x1f, 0x80, 0x3f, 0x00, 0x3e, 0x00, 0x7c, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x78, 0x00,
	0x78, 0x00, 0x78, 0x00, 0x38, 0x00, 0x0b, 0x21, 0x01, 0xc0, 0x03, 0xe0, 0x03, 0xe0, 0x07, 0xf0,
	0x07, 0xf0, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0xe0, 0x07, 0xe0, 0x03, 0xe0, 0x03, 0xe0, 0x03, 0xc0,
	0x03, 0xc0, 0x03, 0xc0, 0x07, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x80, 0x1f, 0x80,
	0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x00, 0x1f, 0x00, 0x3e, 0x00, 0x3c, 0x00, 0x7c, 0x00, 0x78, 0x00,
	0xf0, 0x00, 0xf0, 0x00, 0x70, 0x00, 0x78, 0x00, 0x38, 0x00, 0x08, 0x21, 0x0e, 0x00, 0x1f, 0x00,
	0x1f, 0x00, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x00,
	0x1f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x1f, 0x00, 0x3f, 0x80, 0x7f, 0x80, 0x7f, 0x80,
	0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3c, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x78, 0x00, 0x07, 0x21,
	0x1c, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00,
	0x3f, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x3e, 0x00, 0x7f, 0x00,
	0xff, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x3e, 0x00, 0x3e, 0x00,
	0x3e, 0x00, 0x3c, 0x00, 0x7c, 0x00, 0x78, 0x00, 0x78, 0x00, 0x78, 0x00, 0x78, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x07, 0x21, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x1e, 0x00,
	0x3e, 0x00, 0x7f, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x3c, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x09, 0x21, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x00,
	0x1f, 0x00, 0x1f, 0x00, 0x3f, 0x00, 0x3f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x3f, 0x80,
	0x3f, 0x80, 0x3f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1f, 0x00,
	0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x00, 0x0f, 0x80, 0x0f, 0x80, 0x0e, 0x0c, 0x1f, 0xf0, 0x1f, 0xe0,
	0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0xe0,
	0x7f, 0xf0, 0x7f, 0xfc, 0x0b, 0x17, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xc0,
	0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0x80, 0x3f, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00,
	0xfe, 0x00, 0xfc, 0x00, 0x0f, 0x10, 0xff, 0xe0, 0x7f, 0xe0, 0x7f, 0xf0, 0x3f, 0xf0, 0x1f, 0xf8,
	0x0f, 0xf8, 0x0f, 0xfc, 0x07, 0xfc, 0x03, 0xfe, 0x01, 0xfe, 0x01, 0xfe, 0x00, 0xfe, 0x00, 0x7e,
	0x00, 0x7e, 0x00, 0x7e, 0x00, 0x3f, 0x0f, 0x0f, 0x03, 0x80, 0x0f, 0x80, 0x3f, 0x00, 0xff, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x80, 0x1f, 0xc0, 0x1f, 0xfc, 0x0f, 0xff, 0x0f, 0xfc, 0x0f, 0xf0,
	0x0f, 0xc0, 0x0f, 0x00, 0x0c, 0x00, 0x0d, 0x1e, 0x07, 0x00, 0x0f, 0xc0, 0x0f, 0xe0, 0x1f, 0xf0,
	0x3f, 0xf0, 0x3f, 0xf8, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc,
	0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8,
	0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x7f, 0xfc, 0x7f, 0xfc, 0x7f, 0xfc, 0x7f, 0xfc,
	0x7f, 0xf0, 0x3e, 0x00, 0x10, 0x11, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00, 0x7f, 0xf0,
	0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x1f, 0xf8, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x0f, 0xfe,
	0x00, 0x00, 0x07, 0xfe, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x00, 0xff,
	0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f,
	0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x0b, 0x18, 0x07, 0xf0, 0x07, 0xf0,
	0x07, 0xf0, 0x07, 0xf0, 0x07, 0xe0, 0x07, 0xe0, 0x07, 0xe0, 0x07, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0x80, 0x3f, 0x80,
	0x7f, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xf8, 0x00, 0x10, 0x0f, 0x00, 0xc0,
	0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x7f, 0x80,
	0x00, 0x00, 0xff, 0x80, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xff,
	0x80, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x0f, 0xfc, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x07, 0xc0,
	0x00, 0x00, 0x07, 0x80, 0x00, 0x00, 0x06, 0x00, 0x00, 0x00, 0x0e, 0x13, 0xff, 0xe0, 0x7f, 0xe0,
	0x7f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf8, 0x1f, 0xf8, 0x0f, 0xfc, 0x0f, 0xfc, 0x07, 0xfe, 0x03, 0xfe,
	0x01, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe,
	0x00, 0xfe, 0x10, 0x15, 0x00, 0xff, 0x80, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00, 0xff, 0x00, 0x00,
	0x00, 0xff, 0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00,
	0x01, 0xfe, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00,
	0x01, 0xf8, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf0, 0x00, 0x00,
	0x03, 0xf0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00,
	0x3f, 0x80, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x0f, 0x0e, 0x0f, 0xfe, 0x0f, 0xf8, 0x07, 0xf0,
	0x07, 0xf0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x3f, 0xe0, 0x3f, 0xe0,
	0x7f, 0xf0, 0x1f, 0xf8, 0x00, 0x7e, 0x11, 0x0f, 0x00, 0xc0, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00,
	0x0f, 0xc0, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0xff, 0x80, 0x00, 0x00,
	0x3f, 0x80, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x00,
	0x0f, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,
	0x0f, 0x00, 0x00, 0x00, 0x0d, 0x14, 0xff, 0xc0, 0xff, 0xc0, 0x7f, 0xe0, 0x7f, 0xe0, 0x3f, 0xe0,
	0x3f, 0xf0, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x01, 0xfc,
	0x01, 0xfc, 0x01, 0xfc, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x01, 0xf8, 0x12, 0x14,
	0x00, 0x3f, 0xe0, 0x00, 0x00, 0x3f, 0xe0, 0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x7f, 0xc0, 0x00,
	0x00, 0x7f, 0xc0, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00,
	0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xfe, 0x00, 0x00,
	0x00, 0xfe, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00,
	0x07, 0xf8, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00,
	0x0e, 0x0f, 0x0f, 0x00, 0x0f, 0xc0, 0x07, 0xf0, 0x07, 0xfc, 0x07, 0xf8, 0x0f, 0xf0, 0x0f, 0xe0,
	0x1f, 0xc0, 0x1f, 0xc0, 0x3f, 0x80, 0x7f, 0x80, 0x7f, 0xc0, 0x1f, 0xe0, 0x03, 0xf8, 0x00, 0xfc,
	0x0f, 0x0c, 0xff, 0xc0, 0x7f, 0xc0, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x1f, 0xc0,
	0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xf0, 0x3f, 0xf8, 0x3f, 0xfe, 0x0c, 0x13, 0xff, 0xe0, 0x7f, 0xe0,
	0x7f, 0xe0, 0x3f, 0xf0, 0x3f, 0xf0, 0x1f, 0xf0, 0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xf8, 0x07, 0xf8,
	0x03, 0xf8, 0x03, 0xf8, 0x03, 0xf8, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0,
	0x03, 0xf0, 0x0b, 0x13, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0,
	0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0, 0x07, 0xf0,
	0x07, 0xf0, 0x1f, 0xf0, 0xff, 0xe0, 0xff, 0x80, 0xff, 0x00, 0x0f, 0x10, 0x03, 0xc0, 0x03, 0xe0,
	0x07, 0xf8, 0x07, 0xfc, 0x0f, 0xfe, 0x0f, 0xfe, 0x1f, 0xf8, 0x3f, 0xe0, 0x7f, 0x80, 0xff, 0x00,
	0x7f, 0x80, 0x1f, 0x80, 0x0f, 0xc0, 0x07, 0xc0, 0x01, 0xe0, 0x00, 0xe0, 0x0d, 0x1e, 0x07, 0x80,
	0x0f, 0xc0, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf8, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc,
	0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8,
	0x7f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xfc,
	0x7f, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0xff, 0xe0, 0xf8, 0x00, 0x0a, 0x13, 0xff, 0x80, 0xff, 0x80,
	0x7f, 0x80, 0x7f, 0xc0, 0x7f, 0xc0, 0x7f, 0xc0, 0x3f, 0xc0, 0x3f, 0xc0, 0x3f, 0xe0, 0x1f, 0xe0,
	0x1f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x0f, 0xc0, 0x1f, 0x80,
	0x1f, 0x80, 0x0e, 0x0c, 0xff, 0xc0, 0x7f, 0xc0, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80,
	0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0xe0, 0x7f, 0xf0, 0x7f, 0xfc, 0x0d, 0x1e, 0x06, 0x00,
	0x0f, 0x80, 0x0f, 0xe0, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xf8, 0x7f, 0xf8, 0xff, 0xfc, 0xff, 0xfc,
	0xff, 0xfc, 0xff, 0xfc, 0xff, 0xfc, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8, 0x7f, 0xf8,
	0x3f, 0xf8, 0x3f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x1f, 0xf8, 0x3f, 0xf8, 0x3f, 0xf8, 0x3f, 0xfc,
	0x7f, 0xfc, 0x7f, 0xfc, 0x3f, 0xf0, 0x3f, 0xc0, 0x1f, 0x00, 0x07, 0x12, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00,
	0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0xfc, 0x00,
	0x0d, 0x15, 0xff, 0x80, 0x7f, 0x80, 0x7f, 0xc0, 0x3f, 0xc0, 0x3f, 0xe0, 0x1f, 0xe0, 0x1f, 0xe0,
	0x0f, 0xf0, 0x0f, 0xf0, 0x07, 0xf0, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x01, 0xfc, 0x03, 0xf8,
	0x0f, 0xf0, 0x1f, 0xe0, 0x3f, 0xc0, 0x7f, 0x80, 0x7f, 0x80, 0x3f, 0x00, 0x08, 0x12, 0x3f, 0x80,
	0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80,
	0x3f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x3f, 0x00, 0x3f, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x0d, 0x12, 0xff, 0xc0, 0x7f, 0xc0, 0x7f, 0xe0, 0x3f, 0xe0, 0x3f, 0xe0, 0x1f, 0xf0,
	0x1f, 0xf0, 0x0f, 0xf0, 0x07, 0xf8, 0x07, 0xf8, 0x03, 0xf8, 0x03, 0xfc, 0x01, 0xfc, 0x01, 0xfc,
	0x03, 0xf8, 0x03, 0xf8, 0x07, 0xf0, 0x07, 0xf0, 0x0e, 0x0e, 0x7f, 0x00, 0x3f, 0xe0, 0x3f, 0xc0,
	0x3f, 0xc0, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x00, 0x1f, 0x00, 0x3f, 0x80, 0x3f, 0x80, 0x7f, 0xc0,
	0x7f, 0xc0, 0x3f, 0xf0, 0x01, 0xfc, 0x11, 0x1f, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00,
	0x7e, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00,
	0x7f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00,
	0x1f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
	0x0f, 0xc0, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00,
	0x07, 0xf0, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00,
	0x01, 0xf8, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x1f, 0x80, 0x00,
	0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x0f, 0x80, 0x00, 0x00, 0x07, 0x80, 0x00,
	0x00, 0x07, 0x00, 0x00, 0x12, 0x1e, 0x3c, 0x00, 0x00, 0x00, 0x7e, 0x00, 0x00, 0x00, 0x7e, 0x00,
	0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x7f, 0x00,
	0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x3f, 0x00, 0x00, 0x00, 0x1f, 0x00,
	0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0f, 0xc0,
	0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x03, 0xf8,
	0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 0xfc, 0x00, 0x00, 0x00, 0x7c,
	0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07,
	0xe0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00, 0x03, 0xc0, 0x00, 0x00, 0x03, 0x80, 0x00, 0x0f, 0x1f,
	0x78, 0x00, 0x7c, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1f, 0x80, 0x1f, 0xc0,
	0x1f, 0xe0, 0x1f, 0xe0, 0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0, 0x03, 0xf0, 0x01, 0xf8,
	0x00, 0x7c, 0x00, 0x3e, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1c, 0x0d, 0x20,
	0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3f, 0x00, 0x3f, 0x80,
	0x3f, 0xc0, 0x3f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xe0, 0x03, 0xf0,
	0x01, 0xf0, 0x00, 0xf8, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x78, 0x00, 0x78, 0x00, 0x78, 0x00, 0x70,
	0x0b, 0x21, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3e, 0x00,
	0x3f, 0x00, 0x3f, 0x80, 0x3f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x0f, 0x80,
	0x0f, 0x80, 0x07, 0xc0, 0x03, 0xc0, 0x03, 0xe0, 0x01, 0xe0, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xe0,
	0x01, 0xe0, 0x01, 0xc0, 0x08, 0x21, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x78, 0x00, 0x78, 0x00,
	0x78, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x1e, 0x00, 0x1f, 0x00, 0x0f, 0x00, 0x0f, 0x80, 0x07, 0x80,
	0x07, 0x80, 0x07, 0x80, 0x0f, 0x00, 0x0f, 0x00, 0x07, 0x21, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0x78, 0x00, 0x78, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x3c, 0x00, 0x3e, 0x00,
	0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x07, 0x21, 0x1c, 0x00,
	0x3e, 0x00, 0x3e, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00,
	0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x78, 0x00, 0x78, 0x00, 0x7c, 0x00, 0xfe, 0x00, 0xff, 0x00,
	0xff, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0x7c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x78, 0x00,
	0x09, 0x21, 0x07, 0x00, 0x0f, 0x80, 0x0f, 0x80, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0x80, 0x1f, 0x80,
	0x1f, 0x80, 0x1f, 0x80, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3f, 0x00,
	0x7f, 0x00, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00,
	0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3e, 0x00, 0x3c, 0x00, 0x3c, 0x00, 0x3c, 0x00,
	0x7c, 0x00, 0x7c, 0x00, 0x05, 0x09, 0x3c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0x01, 0x05, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
	0xc0, 0x00, 0xc0, 0x00, 0x06, 0x06, 0x78, 0x00, 0xfc, 0x00, 0xf0, 0x00, 0xf0, 0x00, 0xe0, 0x00,
	0x60, 0x00, 0x02, 0x05, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x06, 0x05,
	0x3c, 0x00, 0x7e, 0x00, 0x1e, 0x00, 0x1e, 0x00, 0x0c, 0x00, 0x04, 0x09, 0xf0, 0x00, 0xf8, 0x00,
	0xf8, 0x00, 0xf8, 0x00, 0xf8, 0x00, 0x78, 0x00, 0x38, 0x00, 0x38, 0x00, 0x18, 0x00, 0x02, 0x05,
	0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x01, 0x05, 0x80, 0x00, 0x80, 0x00,
	0x80, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x08, 0x0d, 0x38, 0x00, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x80, 0x7f, 0x80, 0x3e, 0x00,
	0x38, 0x00, 0x08, 0x0d, 0x0e, 0x00, 0x0e, 0x00, 0x1f, 0x00, 0x1f, 0x00, 0x3f, 0x80, 0x3f, 0x80,
	0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x00, 0xff, 0x00, 0xff, 0x00, 0x3e, 0x00, 0x0e, 0x00, 0x09, 0x0d,
	0x18, 0x00, 0x3c, 0x00, 0x3e, 0x00, 0x7e, 0x00, 0x7f, 0x00, 0xff, 0x80, 0xff, 0x80, 0x7f, 0x80,
	0x7f, 0xc0, 0x3f, 0xc0, 0x3f, 0xc0, 0x1f, 0x00, 0x1c, 0x00, 0x09, 0x0d, 0x06, 0x00, 0x0f, 0x00,
	0x1f, 0x00, 0x1f, 0x80, 0x3f, 0x80, 0x7f, 0xc0, 0x7f, 0xc0, 0x7f, 0x80, 0xff, 0x80, 0xff, 0x00,
	0xff, 0x00, 0x3e, 0x00, 0x0e, 0x00, 0x06, 0x0d, 0x10, 0x00, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00,
	0x7c, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfc, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0xfe, 0x00, 0x06, 0x0d, 0x10, 0x00, 0x38, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7c, 0x00, 0x7e, 0x00,
	0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0x7e, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x04, 0x04,
	0x70, 0x00, 0xf8, 0x00, 0x70, 0x00, 0x60, 0x00, 0x04, 0x04, 0x70, 0x00, 0xf8, 0x00, 0x70, 0x00,
	0x30, 0x00, 0x0a, 0x0e, 0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80, 0x03, 0x80,
	0x07, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xc0, 0x00,
	0x0b, 0x0e, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80,
	0x03, 0x80, 0x07, 0x00, 0x0e, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x09, 0x0f,
	0x01, 0xc0, 0x01, 0xc0, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x03, 0x80, 0x07, 0x00, 0x07, 0x00,
	0x0e, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x07, 0x0f,
	0x07, 0x00, 0x07, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x0e, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x38, 0x00, 0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0x05, 0x11,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00,
	0x38, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xc0, 0x00,
	0xc0, 0x00, 0x03, 0x11, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x03, 0x10, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x03, 0x10, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0x03, 0x10, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0x09, 0x03, 0x01, 0xc0,
	0x0f, 0xc0, 0x3f, 0xc0, 0x07, 0x03, 0xff, 0x00, 0x3f, 0x00, 0x0f, 0x00, 0x06, 0x04, 0xfe, 0x00,
	0x3e, 0x00, 0x1e, 0x00, 0x06, 0x00, 0x08, 0x03, 0x0f, 0x00, 0x1f, 0x00, 0x7c, 0x00, 0x09, 0x03,
	0x0f, 0x00, 0x7f, 0x80, 0x0f, 0x80, 0x07, 0x05, 0x0e, 0x00, 0x0e, 0x00, 0x1f, 0x00, 0x3c, 0x00,
	0x78, 0x00, 0x09, 0x03, 0x03, 0x80, 0x0f, 0x80, 0x3f, 0xc0, 0x05, 0x07, 0x38, 0x00, 0x7c, 0x00,
	0x78, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00, 0xc0, 0x00, 0x0a, 0x0e, 0xe0, 0x00, 0xe0, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x0b, 0x0e, 0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x01, 0xc0,
	0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x09, 0x0f, 0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x07, 0x00, 0x03, 0x80,
	0x01, 0xc0, 0x01, 0xc0, 0x01, 0x80, 0x07, 0x0f, 0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0e, 0x00, 0x0e, 0x00,
	0x07, 0x00, 0x07, 0x00, 0x03, 0x00, 0x05, 0x11, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00,
	0x1c, 0x00, 0x1c, 0x00, 0x1c, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x03, 0x11, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x30, 0x00, 0x30, 0x00, 0x03, 0x10,
	0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x03, 0x10, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0xe0, 0x00,
	0xe0, 0x00, 0x03, 0x10, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00, 0x70, 0x00,
	0xe0, 0x00, 0xe0, 0x00, 0x09, 0x03, 0xe0, 0x00, 0xfc, 0x00, 0xff, 0x00, 0x07, 0x03, 0xff, 0x00,
	0xfc, 0x00, 0xf0, 0x00, 0x06, 0x04, 0xfe, 0x00, 0xf8, 0x00, 0xf0, 0x00, 0xc0, 0x00, 0x08, 0x03,
	0x78, 0x00, 0x7c, 0x00, 0x1f, 0x00, 0x09, 0x03, 0x3c, 0x00, 0x7f, 0x80, 0x7e, 0x00, 0x07, 0x05,
	0x70, 0x00, 0x70, 0x00, 0xf8, 0x00, 0x3c, 0x00, 0x1e, 0x00, 0x09, 0x03, 0x70, 0x00, 0x7c, 0x00,
	0xff, 0x00, 0x05, 0x07, 0x70, 0x00, 0xf8, 0x00, 0x78, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00,
	0x0c, 0x00, 0x0e, 0x0c, 0x3f, 0xf0, 0x1f, 0xf0, 0x0f, 0xe0, 0x0f, 0xe0, 0x07, 0xf0, 0x07, 0xf0,
	0x07, 0xf0, 0x03, 0xf8, 0x03, 0xf8, 0x0f, 0xf8, 0x1f, 0xfc, 0x7f, 0xfc, 0x0e, 0x0c, 0x1f, 0xf8,
	0x1f, 0xf0, 0x0f, 0xe0, 0x0f, 0xe0, 0x1f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x3f, 0x80, 0x3f, 0x80,
	0x3f, 0xe0, 0x7f, 0xf0, 0x7f, 0xfc, 0x0f, 0x12, 0x07, 0xff, 0x07, 0xfe, 0x0f, 0xfe, 0x0f, 0xfc,
	0x1f, 0xf8, 0x1f, 0xf0, 0x3f, 0xf0, 0x3f, 0xe0, 0x7f, 0xc0, 0x7f, 0x80, 0x7f, 0x80, 0xff, 0x00,
	0xfe, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00, 0xff, 0x00, 0x10, 0x0c, 0x03, 0xff,
	0x80, 0x00, 0x03, 0xff, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x01, 0xfc,
	0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x03, 0xf8,
	0x00, 0x00, 0x0f, 0xf8, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x0f, 0x12,
	0xff, 0xe0, 0x7f, 0xe0, 0x7f, 0xf0, 0x3f, 0xf0, 0x1f, 0xf8, 0x0f, 0xf8, 0x0f, 0xfc, 0x07, 0xfc,
	0x03, 0xfe, 0x01, 0xfe, 0x01, 0xfe, 0x00, 0xff, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0xff,
	0x00, 0xff, 0x00, 0xff, 0x10, 0x0c, 0xff, 0xe0, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00, 0x3f, 0xc0,
	0x00, 0x00, 0x3f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x1f, 0xe0,
	0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xf8, 0x00, 0x00, 0x1f, 0xfc,
	0x00, 0x00, 0x1f, 0xff, 0x00, 0x00, 0x0b, 0x0a, 0x07, 0xf0, 0x07, 0xf0, 0x03, 0xf0, 0x1f, 0xf0,
	0xff, 0xf0, 0xff, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x7f, 0xf0, 0x3f, 0xf0, 0x11, 0x0c, 0x03, 0xff,
	0x80, 0x00, 0x3f, 0xff, 0x80, 0x00, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff,
	0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xfe,
	0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x07, 0xf8, 0x00, 0x00, 0x10, 0x0e,
	0x00, 0x30, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x03, 0xf8, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00,
	0xff, 0xf8, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00,
	0x3f, 0xff, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00,
	0x03, 0xf0, 0x00, 0x00, 0x01, 0xf0, 0x00, 0x00, 0x11, 0x1c, 0x00, 0x30, 0x00, 0x00, 0x00, 0xfc,
	0x00, 0x00, 0x01, 0xff, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x03, 0xff, 0x80, 0x00, 0x07, 0xff,
	0x80, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff,
	0x80, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff,
	0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x3f, 0xf8, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x7f, 0xf8,
	0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xe0,
	0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x11, 0x1c, 0x00, 0x30, 0x00, 0x00,
	0x00, 0xfc, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00, 0x03, 0xff, 0x00, 0x00,
	0x07, 0xff, 0x80, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x0f, 0xff, 0x80, 0x00,
	0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00,
	0x3f, 0xfc, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00,
	0xff, 0xf8, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0xff, 0xf8, 0x00, 0x00, 0x7f, 0xe0, 0x00, 0x00,
	0x7f, 0xc0, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x00, 0x3e, 0x00, 0x00, 0x00, 0x11, 0x0c, 0x03, 0xff,
	0x80, 0x00, 0x3f, 0xff, 0x80, 0x00, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff,
	0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x0f, 0xff,
	0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x01, 0xfe, 0x00, 0x00, 0x03, 0xfc, 0x00, 0x00, 0x17, 0x06,
	0x00, 0x7f, 0xff, 0x00, 0x0f, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xff, 0x00, 0x7f, 0xff, 0xfe, 0x00,
	0xff, 0xff, 0xfc, 0x00, 0x07, 0xff, 0x00, 0x00, 0x08, 0x05, 0xfc, 0x00, 0xfe, 0x00, 0xfe, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x18, 0x07, 0x00, 0x3f, 0x00, 0x00, 0x0f, 0xff, 0xc0, 0x00, 0x7f, 0xff,
	0xfc, 0x00, 0x1f, 0xff, 0xff, 0x80, 0x07, 0xff, 0xff, 0x80, 0x01, 0xff, 0xff, 0x00, 0x00, 0x7f,
	0xff, 0x00, 0x0e, 0x06, 0x03, 0xfc, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe, 0x03, 0xfe,
	0x10, 0x07, 0x3f, 0xc0, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff,
	0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x1f, 0x80, 0x00, 0x00, 0x13, 0x06,
	0x1f, 0xe0, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, 0xff, 0xff, 0xe0, 0x00, 0x7f, 0xff, 0xe0, 0x00,
	0x7f, 0xff, 0xf0, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x0f, 0x07, 0x7f, 0x80, 0x7f, 0xf8, 0xff, 0xff,
	0xff, 0xff, 0x7f, 0xff, 0x3f, 0xfc, 0x0f, 0xc0, 0x12, 0x07, 0x1f, 0x80, 0x00, 0x00, 0x7f, 0xfe,
	0x00, 0x00, 0xff, 0xff, 0xe0, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x00, 0x00, 0x3f, 0xf8,
	0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x08, 0x05, 0x1f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x7f, 0x00,
	0x7f, 0x00, 0x09, 0x11, 0x7c, 0x00, 0x7e, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00, 0x7f, 0x00,
	0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x80, 0x1f, 0x80, 0x1f, 0x80, 0x0f, 0x80, 0x0f, 0x80, 0x0f, 0x80,
	0x0f, 0x80, 0x07, 0xc0, 0x07, 0xc0, 0x0e, 0x06, 0x7f, 0x80, 0xff, 0xfe, 0xff, 0xfe, 0xff, 0xfe,
	0xff, 0xfe, 0xff, 0x80, 0x08, 0x11, 0x7c, 0x00, 0x7e, 0x00, 0xfe, 0x00, 0xff, 0x00, 0xff, 0x00,
	0x7f, 0x00, 0x7f, 0x00, 0x7f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x3f, 0x00, 0x1f, 0x00, 0x1f, 0x00,
	0x1f, 0x00, 0x1f, 0x00, 0x0f, 0x80, 0x0f, 0x80, 0x10, 0x07, 0x3e, 0x00, 0x00, 0x00, 0x7f, 0xf8,
	0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0xff, 0xff, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xe0,
	0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x10, 0x0e, 0x06, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x00,
	0x0f, 0xe0, 0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0x80, 0x00, 0x1f, 0xff, 0x00, 0x00,
	0x3f, 0xff, 0x00, 0x00, 0x3f, 0xfe, 0x00, 0x00, 0x7f, 0xfe, 0x00, 0x00, 0x01, 0xf8, 0x00, 0x00,
	0x03, 0xf0, 0x00, 0x00, 0x03, 0xe0, 0x00, 0x00, 0x07, 0xe0, 0x00, 0x00, 0x07, 0xc0, 0x00, 0x00,
	0x11, 0x1c, 0x03, 0x00, 0x00, 0x00, 0x0f, 0xc0, 0x00, 0x00, 0x3f, 0xe0, 0x00, 0x00, 0x3f, 0xf0,
	0x00, 0x00, 0x7f, 0xf0, 0x00, 0x00, 0x7f, 0xf8, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0xff, 0xfc,
	0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x7f, 0xfc,
	0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x1f, 0xfe,
	0x00, 0x00, 0x0f, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00, 0x07, 0xff, 0x00, 0x00, 0x07, 0xff,
	0x00, 0x00, 0x07, 0xff, 0x80, 0x00, 0x07, 0xff, 0x80, 0x00, 0x07, 0xff, 0x80, 0x00, 0x07, 0xff,
	0xc0, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x01, 0xff, 0x80, 0x00, 0x00, 0x7f, 0x80, 0x00, 0x00, 0x1f,
	0x00, 0x00, 0x11, 0x0c, 0x7f, 0xf0, 0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x00,
	0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x3f, 0xff, 0x80, 0x00,
	0x3f, 0xff, 0x00, 0x00, 0x1f, 0xfc, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x07, 0xf0, 0x00, 0x00,
	0x07, 0xf8, 0x00, 0x00, 0x0b, 0x0a, 0xfe, 0x00, 0xfe, 0x00, 0xfc, 0x00, 0xff, 0x80, 0xff, 0xf0,
	0xff, 0xf0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xc0, 0x11, 0x1c, 0x03, 0x00, 0x00, 0x00,
	0x0f, 0xc0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00, 0x3f, 0xf0, 0x00, 0x00,
	0x7f, 0xf8, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0xff, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00,
	0x7f, 0xfc, 0x00, 0x00, 0x7f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00, 0x3f, 0xfc, 0x00, 0x00,
	0x3f, 0xfc, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x1f, 0xfe, 0x00, 0x00, 0x0f, 0xff, 0x00, 0x00,
	0x0f, 0xff, 0x00, 0x00, 0x07, 0xff, 0x80, 0x00, 0x07, 0xff, 0x80, 0x00, 0x07, 0xff, 0x80, 0x00,
	0x07, 0xff, 0xc0, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x07, 0xff, 0xc0, 0x00, 0x01, 0xff, 0x80, 0x00,
	0x00, 0xff, 0x80, 0x00, 0x00, 0x7f, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x11, 0x0c, 0x7f, 0xf0,
	0x00, 0x00, 0x7f, 0xff, 0x00, 0x00, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xc0, 0x00, 0x7f, 0xff,
	0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x3f, 0xff, 0x00, 0x00, 0x3f, 0xfc,
	0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x1f, 0xe0, 0x00, 0x00, 0x0f, 0xf0, 0x00, 0x00, 0x0a, 0x0d,
	0x1f, 0x00, 0x7f, 0xc0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0x7f, 0xc0, 0x7f, 0xc0, 0x7f, 0xc0,
	0x7f, 0xc0, 0x7f, 0xc0, 0x3f, 0x80, 0x3f, 0x80, 0x3f, 0x80, 0x0e, 0x03, 0x03, 0xf8, 0xff, 0xf8,
	0xff, 0x00, 0x13, 0x03, 0x00, 0x0f, 0xc0, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00,
	0x11, 0x02, 0xff, 0xff, 0x00, 0x00, 0x7f, 0xc0, 0x00, 0x00, 0x13, 0x03, 0x3f, 0x00, 0x00, 0x00,
	0x03, 0xf8, 0x00, 0x00, 0x00, 0x3f, 0x80, 0x00, 0x11, 0x02, 0x3f, 0xff, 0xc0, 0x00, 0x00, 0xff,
	0x80, 0x00, 0x0e, 0x08, 0x00, 0x1c, 0x00, 0xf0, 0x07, 0xc0, 0x3f, 0x00, 0x06, 0x00, 0x06, 0x00,
	0x06, 0x00, 0x07, 0x00, 0x10, 0x06, 0x3f, 0xfe, 0x00, 0x00, 0x1f, 0xc0, 0x00, 0x00, 0x0c, 0x00,
	0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x70, 0x00, 0x00, 0x00, 0x0e, 0x08,
	0x70, 0x00, 0x1e, 0x00, 0x07, 0xc0, 0x01, 0xf8, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x01, 0xc0,
	0x10, 0x06, 0x3f, 0xfe, 0x00, 0x00, 0x01, 0xfc, 0x00, 0x00, 0x00, 0x18, 0x00, 0x00, 0x00, 0x0c,
	0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00, 0x07, 0x00, 0x00, 0x09, 0x0b, 0x03, 0x00, 0x07, 0x80,
	0x0f, 0xc0, 0x1f, 0xc0, 0x1f, 0xc0, 0x3f, 0x80, 0x7f, 0x80, 0x7f, 0x80, 0x7f, 0x00, 0xff, 0x00,
	0xfe, 0x00, 0x11, 0x02, 0x3f, 0xff, 0xc0, 0x00, 0x7f, 0xff, 0xc0, 0x00, 0x10, 0x03, 0x3f, 0xe0,
	0x00, 0x00, 0x7f, 0xff, 0x80, 0x00, 0x00, 0xff, 0x80, 0x00, 0x09, 0x0b, 0x30, 0x00, 0x78, 0x00,
	0xfc, 0x00, 0xfe, 0x00, 0xfe, 0x00, 0x7f, 0x00, 0x7f, 0x80, 0x7f, 0x80, 0x3f, 0x80, 0x3f, 0xc0,
	0x1f, 0xc0, 0x11, 0x02, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0x80, 0x00, 0x04, 0x08, 0x38, 0x00,
	0x38, 0x00, 0x30, 0x00, 0x70, 0x00, 0x70, 0x00, 0x60, 0x00, 0x60, 0x00, 0xc0, 0x00, 0x03, 0x09,
	0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x03, 0x08, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x70, 0x00,
	0x70, 0x00, 0x30, 0x00, 0x04, 0x08, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x03, 0x09, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x60, 0x00,
	0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0x05, 0x09, 0x0c, 0x00, 0x0c, 0x00,
	0x18, 0x00, 0x18, 0x00, 0x30, 0x00, 0x30, 0x00, 0x60, 0x00, 0x60, 0x00, 0xc0, 0x00, 0x07, 0x08,
	0x03, 0x00, 0x06, 0x00, 0x06, 0x00, 0x0c, 0x00, 0x1c, 0x00, 0x38, 0x00, 0x30, 0x00, 0x70, 0x00,
	0x02, 0x08, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x60, 0x00,
	0x60, 0x00, 0x07, 0x09, 0x01, 0x00, 0x01, 0x00, 0x02, 0x00, 0x02, 0x00, 0x06, 0x00, 0x04, 0x00,
	0x3c, 0x00, 0xfc, 0x00, 0xf0, 0x00, 0x03, 0x0a, 0x10, 0x00, 0x10, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x20, 0x00, 0x60, 0x00, 0x60, 0x00, 0x40, 0x00, 0xc0, 0x00, 0x03, 0x08, 0xc0, 0x00,
	0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x30, 0x00, 0x05, 0x0b,
	0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x04, 0x00, 0x0c, 0x00, 0x0c, 0x00,
	0x1c, 0x00, 0x3c, 0x00, 0x78, 0x00, 0x04, 0x0a, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00,
	0x60, 0x00, 0x60, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x04, 0x0b, 0x40, 0x00,
	0x40, 0x00, 0x60, 0x00, 0x20, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0x10, 0x00, 0x18, 0x00,
	0xf0, 0x00, 0xf0, 0x00, 0x05, 0x09, 0xc0, 0x00, 0xc0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x30, 0x00,
	0x30, 0x00, 0x18, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x06, 0x07, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x38, 0x00, 0x18, 0x00, 0x0c, 0x00, 0x0c, 0x00, 0x08, 0x09, 0x80, 0x00, 0xc0, 0x00, 0x40, 0x00,
	0x60, 0x00, 0x30, 0x00, 0x30, 0x00, 0x1f, 0x80, 0x1f, 0x00, 0x0e, 0x00, 0x01, 0x09, 0xc0, 0x00,
	0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00, 0xc0, 0x00,
	0x06, 0x07, 0xe0, 0x00, 0x70, 0x00, 0x70, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1c, 0x00, 0x1c, 0x00,
	0x03, 0x08, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00,
	0xc0, 0x00, 0x05, 0x0b, 0x80, 0x00, 0x80, 0x00, 0xc0, 0x00, 0x40, 0x00, 0x40, 0x00, 0x60, 0x00,
	0x60, 0x00, 0x20, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0x00, 0x04, 0x07, 0xe0, 0x00, 0xe0, 0x00,
	0x70, 0x00, 0x70, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0x00, 0x04, 0x0a, 0x18, 0x00, 0x18, 0x00,
	0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xc0, 0x00,
	0x03, 0x08, 0xe0, 0x00, 0xe0, 0x00, 0xe0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x70, 0x00, 0x70, 0x00,
	0x30, 0x00, 0x05, 0x09, 0x0c, 0x00, 0x0c, 0x00, 0x18, 0x00, 0x18, 0x00, 0x30, 0x00, 0x30, 0x00,
	0x60, 0x00, 0x60, 0x00, 0xc0, 0x00, 0x04, 0x0b, 0x10, 0x00, 0x10, 0x00, 0x30, 0x00, 0x20, 0x00,
	0x20, 0x00, 0x60, 0x00, 0x60, 0x00, 0x40, 0x00, 0xc0, 0x00, 0x78, 0x00, 0x78, 0x00, 0x05, 0x0b,
	0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0x80, 0x00, 0xc0, 0x00, 0xc0, 0x00,
	0xe0, 0x00, 0xf0, 0x00, 0x78, 0x00, 0x06, 0x04, 0xf0, 0x00, 0x78, 0x00, 0x18, 0x00, 0x0c, 0x00,
	0x06, 0x04, 0x1e, 0x00, 0x3c, 0x00, 0x30, 0x00, 0x60, 0x00, 0x0a, 0x0a, 0x7f, 0x00, 0x7f, 0xc0,
	0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xc0, 0xff, 0x00, 0x7e, 0x00,
	0x0a, 0x0a, 0x1f, 0xc0, 0x7f, 0xc0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0, 0xff, 0xe0,
	0x7f, 0xe0, 0x1f, 0xe0, 0x0f, 0xc0
};

// from https://en.wikipedia.org/wiki/Enhanced_Graphics_Adapter
const uint8_t Video::_paletteEGA[] = {
        0x00, 0x00, 0x00, // black #0
        0x00, 0x00, 0xAA, // blue #1
        0x00, 0xAA, 0x00, // green #2
        0x00, 0xAA, 0xAA, // cyan #3
        0xAA, 0x00, 0x00, // red #4
        0xAA, 0x00, 0xAA, // magenta #5
        0xAA, 0x55, 0x00, // yellow, brown #20
        0xAA, 0xAA, 0xAA, // white, light gray #7
        0x55, 0x55, 0x55, // dark gray, bright black #56
        0x55, 0x55, 0xFF, // bright blue #57
        0x55, 0xFF, 0x55, // bright green #58
        0x55, 0xFF, 0xFF, // bright cyan #59
        0xFF, 0x55, 0x55, // bright red #60
        0xFF, 0x55, 0xFF, // bright magenta #61
        0xFF, 0xFF, 0x55, // bright yellow #62
        0xFF, 0xFF, 0xFF, // bright white #63
};

const AmigaMemEntry Resource::_memListAmigaFR[146] = {
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x1, 0x000000, 0x1A3C, 0x1A3C },
	{ 0, 0x1, 0x001A3C, 0x2E34, 0x2E34 },
	{ 0, 0x1, 0x004870, 0x69F8, 0x69F8 },
	{ 0, 0x1, 0x00B268, 0x45CE, 0x45CE },
	{ 0, 0x1, 0x00F836, 0x0EFA, 0x0EFA },
	{ 0, 0x1, 0x010730, 0x0D26, 0x0D26 },
	{ 1, 0x1, 0x011456, 0x0494, 0x3CC0 },
	{ 0, 0x2, 0x000000, 0x2674, 0x2674 },
	{ 0, 0x1, 0x0118EA, 0x2BB6, 0x2BB6 },
	{ 0, 0x1, 0x0144A0, 0x2BB4, 0x2BB4 },
	{ 0, 0x1, 0x017054, 0x0426, 0x0426 },
	{ 0, 0x1, 0x01747A, 0x1852, 0x1852 },
	{ 0, 0x1, 0x018CCC, 0x0594, 0x0594 },
	{ 0, 0x1, 0x019260, 0x13F0, 0x13F0 },
	{ 0, 0x1, 0x01A650, 0x079E, 0x079E },
	{ 0, 0x2, 0x002674, 0x56A2, 0x56A2 },
	{ 6, 0xC, 0x000000, 0x6214, 0x6214 },
	{ 2, 0x5, 0x000000, 0x2410, 0x7D00 },
	{ 2, 0x5, 0x002410, 0x7D00, 0x7D00 },
	{ 3, 0x1, 0x01ADEE, 0x0800, 0x0800 },
	{ 4, 0x1, 0x01B5EE, 0x0D2A, 0x0D2A },
	{ 5, 0x1, 0x01C318, 0x107C, 0x107C },
	{ 3, 0x1, 0x01D394, 0x0800, 0x0800 },
	{ 4, 0x1, 0x01DB94, 0x2530, 0x2530 },
	{ 5, 0x1, 0x0200C4, 0xFE7A, 0xFE7A },
	{ 3, 0x2, 0x007D16, 0x0800, 0x0800 },
	{ 4, 0x2, 0x008516, 0x4BD0, 0x4BD0 },
	{ 5, 0x2, 0x00D0E6, 0xFDBA, 0xFDBA },
	{ 3, 0xD, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xD, 0x000800, 0x974A, 0x974A },
	{ 5, 0xD, 0x009F4A, 0xD1D8, 0xD1D8 },
	{ 3, 0x3, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x3, 0x000800, 0xED30, 0xED30 },
	{ 5, 0x3, 0x00F530, 0xFEF6, 0xFEF6 },
	{ 3, 0xA, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xA, 0x000800, 0x1B00, 0x1B00 },
	{ 5, 0xA, 0x002300, 0x5E58, 0x5E58 },
	{ 3, 0xA, 0x008158, 0x0800, 0x0800 },
	{ 4, 0xA, 0x008958, 0x99D8, 0x99D8 },
	{ 5, 0xA, 0x012330, 0xFF9A, 0xFF9A },
	{ 3, 0xB, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xB, 0x000800, 0x09F4, 0x09F4 },
	{ 5, 0xB, 0x0011F4, 0x4E36, 0x4E36 },
	{ 0, 0x1, 0x02FF3E, 0x0372, 0x0372 },
	{ 0, 0x2, 0x01CEA0, 0x1E04, 0x1E04 },
	{ 0, 0x1, 0x0302B0, 0x08EA, 0x08EA },
	{ 0, 0x1, 0x030B9A, 0x1A46, 0x1A46 },
	{ 0, 0x2, 0x01ECA4, 0x343E, 0x343E },
	{ 0, 0x2, 0x0220E2, 0x149E, 0x149E },
	{ 0, 0x2, 0x023580, 0x1866, 0x1866 },
	{ 0, 0x1, 0x0325E0, 0x0266, 0x0266 },
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x2, 0x024DE6, 0x01A8, 0x01A8 },
	{ 0, 0x1, 0x032846, 0x1FEC, 0x1FEC },
	{ 0, 0x2, 0x024F8E, 0x13A4, 0x13A4 },
	{ 0, 0x2, 0x026332, 0x15C4, 0x15C4 },
	{ 0, 0x2, 0x0278F6, 0x0E2A, 0x0E2A },
	{ 0, 0x2, 0x028720, 0x0366, 0x0366 },
	{ 0, 0x2, 0x028A86, 0x0078, 0x0078 },
	{ 0, 0x2, 0x028AFE, 0x1392, 0x1392 },
	{ 0, 0x2, 0x029E90, 0x06E0, 0x06E0 },
	{ 0, 0x2, 0x02A570, 0x21AE, 0x21AE },
	{ 0, 0x1, 0x034832, 0x04FA, 0x04FA },
	{ 0, 0x1, 0x034D2C, 0x129E, 0x129E },
	{ 0, 0x1, 0x035FCA, 0x09B4, 0x09B4 },
	{ 0, 0x2, 0x02C71E, 0x04EC, 0x04EC },
	{ 2, 0x4, 0x000000, 0x28FC, 0x7D00 },
	{ 2, 0x4, 0x0028FC, 0x1C2C, 0x7D00 },
	{ 2, 0x4, 0x004528, 0x1F20, 0x7D00 },
	{ 2, 0x4, 0x006448, 0x22A8, 0x7D00 },
	{ 2, 0x1, 0x03697E, 0x033C, 0x7D00 },
	{ 2, 0x4, 0x0086F0, 0x2DA4, 0x7D00 },
	{ 2, 0x4, 0x00B494, 0x3008, 0x7D00 },
	{ 0, 0x2, 0x02CC0A, 0x03C0, 0x03C0 },
	{ 0, 0x2, 0x02CFCA, 0x13E6, 0x13E6 },
	{ 0, 0x2, 0x02E3B0, 0x04DE, 0x04DE },
	{ 0, 0x2, 0x02E88E, 0x05FA, 0x05FA },
	{ 0, 0x2, 0x02EE88, 0x025E, 0x025E },
	{ 0, 0x2, 0x02F0E6, 0x0642, 0x0642 },
	{ 0, 0x2, 0x02F728, 0x19D0, 0x19D0 },
	{ 0, 0x2, 0x0310F8, 0x00E8, 0x00E8 },
	{ 0, 0x6, 0x000000, 0x1022, 0x1022 },
	{ 2, 0x1, 0x036CBA, 0x1A8C, 0x7D00 },
	{ 0, 0x2, 0x0311E0, 0x58AA, 0x58AA },
	{ 0, 0x6, 0x001022, 0x0990, 0x0990 },
	{ 0, 0x6, 0x0019B2, 0x2C42, 0x2C42 },
	{ 0, 0x6, 0x0045F4, 0x152C, 0x152C },
	{ 0, 0x6, 0x005B20, 0x05B4, 0x05B4 },
	{ 0, 0x6, 0x0060D4, 0x23B4, 0x23B4 },
	{ 0, 0x6, 0x008488, 0x1FA4, 0x1FA4 },
	{ 0, 0x6, 0x00A42C, 0x0D20, 0x0D20 },
	{ 0, 0x6, 0x00B14C, 0x0528, 0x0528 },
	{ 0, 0x6, 0x00B674, 0x1608, 0x1608 },
	{ 0, 0x6, 0x00CC7C, 0x01EA, 0x01EA },
	{ 0, 0x6, 0x00CE66, 0x07EA, 0x07EA },
	{ 0, 0x6, 0x00D650, 0x00E8, 0x00E8 },
	{ 0, 0x7, 0x000000, 0x3978, 0x3978 },
	{ 0, 0x7, 0x003978, 0x1178, 0x1178 },
	{ 0, 0x7, 0x004AF0, 0x14B0, 0x14B0 },
	{ 0, 0x7, 0x005FA0, 0x0AA4, 0x0AA4 },
	{ 0, 0x7, 0x006A44, 0x02DA, 0x02DA },
	{ 0, 0x7, 0x006D1E, 0x2674, 0x2674 },
	{ 0, 0x7, 0x009392, 0x12F0, 0x12F0 },
	{ 0, 0x7, 0x00A682, 0x5D58, 0x5D58 },
	{ 0, 0x7, 0x0103DA, 0xA222, 0xA222 },
	{ 0, 0x8, 0x000000, 0x2E68, 0x2E68 },
	{ 0, 0x8, 0x002E68, 0x51C6, 0x51C6 },
	{ 0, 0x8, 0x00802E, 0x13E6, 0x13E6 },
	{ 0, 0x8, 0x009414, 0x149E, 0x149E },
	{ 0, 0x8, 0x00A8B2, 0x58AA, 0x58AA },
	{ 0, 0x8, 0x01015C, 0x445C, 0x445C },
	{ 0, 0x7, 0x01A5FC, 0x0D90, 0x0D90 },
	{ 0, 0x7, 0x01B38C, 0x09E4, 0x09E4 },
	{ 0, 0x7, 0x01BD70, 0x198A, 0x198A },
	{ 0, 0x7, 0x01D6FA, 0x25D2, 0x25D2 },
	{ 0, 0x8, 0x0145B8, 0x2430, 0x2430 },
	{ 0, 0x8, 0x0169E8, 0x1316, 0x1316 },
	{ 0, 0x8, 0x017CFE, 0x0220, 0x0220 },
	{ 0, 0x8, 0x017F1E, 0x05EA, 0x05EA },
	{ 0, 0x8, 0x018508, 0x043C, 0x043C },
	{ 0, 0x8, 0x018944, 0x08EA, 0x08EA },
	{ 0, 0x8, 0x01922E, 0x1478, 0x1478 },
	{ 0, 0x8, 0x01A6A6, 0x432E, 0x432E },
	{ 0, 0x8, 0x01E9D4, 0x06CE, 0x06CE },
	{ 3, 0x9, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x9, 0x000800, 0x0CC6, 0x0CC6 },
	{ 5, 0x9, 0x0014C6, 0x13B8, 0x13B8 },
	{ 0, 0x1, 0x038746, 0x189A, 0x189A },
	{ 0, 0x1, 0x039FE0, 0x07D8, 0x07D8 },
	{ 0, 0x1, 0x03A7B8, 0x0462, 0x0462 },
	{ 0, 0x1, 0x03AC1A, 0x0FA8, 0x0FA8 },
	{ 0, 0xA, 0x0222CA, 0x672E, 0x672E },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x01F0A2, 0x247C, 0x247C },
	{ 1, 0x2, 0x036A8A, 0x08C0, 0x08C0 },
	{ 1, 0xB, 0x00602A, 0x08C4, 0x3CC0 },
	{ 0, 0xA, 0x0289F8, 0x4F5A, 0x4F5A },
	{ 0, 0xA, 0x02D952, 0x4418, 0x4418 },
	{ 0, 0xA, 0x031D6A, 0x293C, 0x293C },
	{ 0, 0xA, 0x0346A6, 0x3FC8, 0x3FC8 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 2, 0xB, 0x0068EE, 0x2F94, 0x7D00 },
	{ 2, 0xB, 0x009882, 0x33C0, 0x7D00 },
};

const AmigaMemEntry Resource::_memListAmigaEN[146] = {
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x1, 0x000000, 0x1A3C, 0x1A3C },
	{ 0, 0x1, 0x001A3C, 0x2E34, 0x2E34 },
	{ 0, 0x1, 0x004870, 0x69F8, 0x69F8 },
	{ 0, 0x1, 0x00B268, 0x45CE, 0x45CE },
	{ 0, 0x1, 0x00F836, 0x0EFA, 0x0EFA },
	{ 0, 0x1, 0x010730, 0x0D26, 0x0D26 },
	{ 1, 0x1, 0x011456, 0x0494, 0x3CC0 },
	{ 0, 0x2, 0x000000, 0x2674, 0x2674 },
	{ 0, 0x1, 0x0118EA, 0x2BB6, 0x2BB6 },
	{ 0, 0x1, 0x0144A0, 0x2BB4, 0x2BB4 },
	{ 0, 0x1, 0x017054, 0x0426, 0x0426 },
	{ 0, 0x1, 0x01747A, 0x1852, 0x1852 },
	{ 0, 0x1, 0x018CCC, 0x0594, 0x0594 },
	{ 0, 0x1, 0x019260, 0x13F0, 0x13F0 },
	{ 0, 0x1, 0x01A650, 0x079E, 0x079E },
	{ 0, 0x2, 0x002674, 0x56A2, 0x56A2 },
	{ 6, 0xC, 0x000000, 0x6214, 0x6214 },
	{ 2, 0x5, 0x000000, 0x2410, 0x7D00 },
	{ 2, 0x5, 0x002410, 0x7D00, 0x7D00 },
	{ 3, 0x1, 0x01ADEE, 0x0800, 0x0800 },
	{ 4, 0x1, 0x01B5EE, 0x0DD8, 0x0DD8 },
	{ 5, 0x1, 0x01C3C6, 0x1090, 0x1090 },
	{ 3, 0x1, 0x01D456, 0x0800, 0x0800 },
	{ 4, 0x1, 0x01DC56, 0x2530, 0x2530 },
	{ 5, 0x1, 0x020186, 0xFE7A, 0xFE7A },
	{ 3, 0x2, 0x007D16, 0x0800, 0x0800 },
	{ 4, 0x2, 0x008516, 0x4C02, 0x4C02 },
	{ 5, 0x2, 0x00D118, 0xFDBA, 0xFDBA },
	{ 3, 0xD, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xD, 0x000800, 0x98B6, 0x98B6 },
	{ 5, 0xD, 0x00A0B6, 0xD1D8, 0xD1D8 },
	{ 3, 0x3, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x3, 0x000800, 0xEE5E, 0xEE5E },
	{ 5, 0x3, 0x00F65E, 0xFD08, 0xFD08 },
	{ 3, 0xA, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xA, 0x000800, 0x1B00, 0x1B00 },
	{ 5, 0xA, 0x002300, 0x5E58, 0x5E58 },
	{ 3, 0xA, 0x008158, 0x0800, 0x0800 },
	{ 4, 0xA, 0x008958, 0x99DC, 0x99DC },
	{ 5, 0xA, 0x012334, 0xFF9A, 0xFF9A },
	{ 3, 0xB, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xB, 0x000800, 0x09F4, 0x09F4 },
	{ 5, 0xB, 0x0011F4, 0x4E3A, 0x4E3A },
	{ 0, 0x1, 0x030000, 0x0372, 0x0372 },
	{ 0, 0x2, 0x01CED2, 0x1E04, 0x1E04 },
	{ 0, 0x1, 0x030372, 0x08EA, 0x08EA },
	{ 0, 0x1, 0x030C5C, 0x1A46, 0x1A46 },
	{ 0, 0x2, 0x01ECD6, 0x343E, 0x343E },
	{ 0, 0x2, 0x022114, 0x149E, 0x149E },
	{ 0, 0x2, 0x0235B2, 0x1866, 0x1866 },
	{ 0, 0x1, 0x0326A2, 0x0266, 0x0266 },
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x2, 0x024E18, 0x01A8, 0x01A8 },
	{ 0, 0x1, 0x032908, 0x1FEC, 0x1FEC },
	{ 0, 0x2, 0x024FC0, 0x13A4, 0x13A4 },
	{ 0, 0x2, 0x026364, 0x15C4, 0x15C4 },
	{ 0, 0x2, 0x027928, 0x0E2A, 0x0E2A },
	{ 0, 0x2, 0x028752, 0x0366, 0x0366 },
	{ 0, 0x2, 0x028AB8, 0x0078, 0x0078 },
	{ 0, 0x2, 0x028B30, 0x1392, 0x1392 },
	{ 0, 0x2, 0x029EC2, 0x06E0, 0x06E0 },
	{ 0, 0x2, 0x02A5A2, 0x21AE, 0x21AE },
	{ 0, 0x1, 0x0348F4, 0x04FA, 0x04FA },
	{ 0, 0x1, 0x034DEE, 0x129E, 0x129E },
	{ 0, 0x1, 0x03608C, 0x09B4, 0x09B4 },
	{ 0, 0x2, 0x02C750, 0x04EC, 0x04EC },
	{ 2, 0x4, 0x000000, 0x28FC, 0x7D00 },
	{ 2, 0x4, 0x0028FC, 0x1C2C, 0x7D00 },
	{ 2, 0x4, 0x004528, 0x1F20, 0x7D00 },
	{ 2, 0x4, 0x006448, 0x22A8, 0x7D00 },
	{ 2, 0x1, 0x036A40, 0x033C, 0x7D00 },
	{ 2, 0x4, 0x0086F0, 0x2DA4, 0x7D00 },
	{ 2, 0x4, 0x00B494, 0x3008, 0x7D00 },
	{ 0, 0x2, 0x02CC3C, 0x03C0, 0x03C0 },
	{ 0, 0x2, 0x02CFFC, 0x13E6, 0x13E6 },
	{ 0, 0x2, 0x02E3E2, 0x04DE, 0x04DE },
	{ 0, 0x2, 0x02E8C0, 0x05FA, 0x05FA },
	{ 0, 0x2, 0x02EEBA, 0x025E, 0x025E },
	{ 0, 0x2, 0x02F118, 0x0642, 0x0642 },
	{ 0, 0x2, 0x02F75A, 0x19D0, 0x19D0 },
	{ 0, 0x2, 0x03112A, 0x00E8, 0x00E8 },
	{ 0, 0x6, 0x000000, 0x1022, 0x1022 },
	{ 2, 0x1, 0x036D7C, 0x1A8C, 0x7D00 },
	{ 0, 0x2, 0x031212, 0x58AA, 0x58AA },
	{ 0, 0x6, 0x001022, 0x0990, 0x0990 },
	{ 0, 0x6, 0x0019B2, 0x2C42, 0x2C42 },
	{ 0, 0x6, 0x0045F4, 0x152C, 0x152C },
	{ 0, 0x6, 0x005B20, 0x05B4, 0x05B4 },
	{ 0, 0x6, 0x0060D4, 0x23B4, 0x23B4 },
	{ 0, 0x6, 0x008488, 0x1FA4, 0x1FA4 },
	{ 0, 0x6, 0x00A42C, 0x0D20, 0x0D20 },
	{ 0, 0x6, 0x00B14C, 0x0528, 0x0528 },
	{ 0, 0x6, 0x00B674, 0x1608, 0x1608 },
	{ 0, 0x6, 0x00CC7C, 0x01EA, 0x01EA },
	{ 0, 0x6, 0x00CE66, 0x07EA, 0x07EA },
	{ 0, 0x6, 0x00D650, 0x00E8, 0x00E8 },
	{ 0, 0x7, 0x000000, 0x3978, 0x3978 },
	{ 0, 0x7, 0x003978, 0x1178, 0x1178 },
	{ 0, 0x7, 0x004AF0, 0x14B0, 0x14B0 },
	{ 0, 0x7, 0x005FA0, 0x0AA4, 0x0AA4 },
	{ 0, 0x7, 0x006A44, 0x02DA, 0x02DA },
	{ 0, 0x7, 0x006D1E, 0x2674, 0x2674 },
	{ 0, 0x7, 0x009392, 0x12F0, 0x12F0 },
	{ 0, 0x7, 0x00A682, 0x5D58, 0x5D58 },
	{ 0, 0x7, 0x0103DA, 0xA222, 0xA222 },
	{ 0, 0x8, 0x000000, 0x2E68, 0x2E68 },
	{ 0, 0x8, 0x002E68, 0x51C6, 0x51C6 },
	{ 0, 0x8, 0x00802E, 0x13E6, 0x13E6 },
	{ 0, 0x8, 0x009414, 0x149E, 0x149E },
	{ 0, 0x8, 0x00A8B2, 0x58AA, 0x58AA },
	{ 0, 0x8, 0x01015C, 0x445C, 0x445C },
	{ 0, 0x7, 0x01A5FC, 0x0D90, 0x0D90 },
	{ 0, 0x7, 0x01B38C, 0x09E4, 0x09E4 },
	{ 0, 0x7, 0x01BD70, 0x198A, 0x198A },
	{ 0, 0x7, 0x01D6FA, 0x25D2, 0x25D2 },
	{ 0, 0x8, 0x0145B8, 0x2430, 0x2430 },
	{ 0, 0x8, 0x0169E8, 0x1316, 0x1316 },
	{ 0, 0x8, 0x017CFE, 0x0220, 0x0220 },
	{ 0, 0x8, 0x017F1E, 0x05EA, 0x05EA },
	{ 0, 0x8, 0x018508, 0x043C, 0x043C },
	{ 0, 0x8, 0x018944, 0x08EA, 0x08EA },
	{ 0, 0x8, 0x01922E, 0x1478, 0x1478 },
	{ 0, 0x8, 0x01A6A6, 0x432E, 0x432E },
	{ 0, 0x8, 0x01E9D4, 0x06CE, 0x06CE },
	{ 3, 0x9, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x9, 0x000800, 0x0CC6, 0x0CC6 },
	{ 5, 0x9, 0x0014C6, 0x13B8, 0x13B8 },
	{ 0, 0x1, 0x038808, 0x189A, 0x189A },
	{ 0, 0x1, 0x03A0A2, 0x07D8, 0x07D8 },
	{ 0, 0x1, 0x03A87A, 0x0462, 0x0462 },
	{ 0, 0x1, 0x03ACDC, 0x0FA8, 0x0FA8 },
	{ 0, 0xA, 0x0222CE, 0x672E, 0x672E },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x01F0A2, 0x247C, 0x247C },
	{ 1, 0x2, 0x036ABC, 0x08C0, 0x08C0 },
	{ 1, 0xB, 0x00602E, 0x08C4, 0x3CC0 },
	{ 0, 0xA, 0x0289FC, 0x4F5A, 0x4F5A },
	{ 0, 0xA, 0x02D956, 0x4418, 0x4418 },
	{ 0, 0xA, 0x031D6E, 0x293C, 0x293C },
	{ 0, 0xA, 0x0346AA, 0x3FC8, 0x3FC8 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 2, 0xB, 0x0068F2, 0x2F94, 0x7D00 },
	{ 2, 0xB, 0x009886, 0x33C0, 0X7D00 },
};

const AmigaMemEntry Resource::_memListAtariEN[146] = {
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x1, 0x000000, 0x1A3C, 0x1A3C },
	{ 0, 0x1, 0x001A3C, 0x2E34, 0x2E34 },
	{ 0, 0x1, 0x004870, 0x69F8, 0x69F8 },
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x1, 0x00B268, 0x0EFA, 0x0EFA },
	{ 0, 0x1, 0x00C162, 0x0D26, 0x0D26 },
	{ 1, 0x1, 0x00CE88, 0x0494, 0x3CC0 },
	{ 0, 0x2, 0x000000, 0x2674, 0x2674 },
	{ 0, 0x1, 0x00D31C, 0x2BB6, 0x2BB6 },
	{ 0, 0x1, 0x00FED2, 0x2BB4, 0x2BB4 },
	{ 0, 0x1, 0x012A86, 0x0426, 0x0426 },
	{ 0, 0x1, 0x012EAC, 0x1852, 0x1852 },
	{ 0, 0x1, 0x0146FE, 0x0594, 0x0594 },
	{ 0, 0x1, 0x014C92, 0x13F0, 0x13F0 },
	{ 0, 0x1, 0x016082, 0x079E, 0x079E },
	{ 0, 0x2, 0x002674, 0x56A2, 0x56A2 },
	{ 6, 0xC, 0x000000, 0x6214, 0x6214 },
	{ 2, 0x5, 0x000000, 0x0000, 0x0000 },
	{ 2, 0x5, 0x000000, 0x0000, 0x0000 },
	{ 3, 0x1, 0x016820, 0x0800, 0x0800 },
	{ 4, 0x1, 0x017020, 0x0DD8, 0x0DD8 },
	{ 5, 0x1, 0x017DF8, 0x1090, 0x1090 },
	{ 3, 0x1, 0x018E88, 0x0800, 0x0800 },
	{ 4, 0x1, 0x019688, 0x2530, 0x2530 },
	{ 5, 0x1, 0x01BBB8, 0xFE7A, 0xFE7A },
	{ 3, 0x2, 0x007D16, 0x0800, 0x0800 },
	{ 4, 0x2, 0x008516, 0x4C02, 0x4C02 },
	{ 5, 0x2, 0x00D118, 0xFDBA, 0xFDBA },
	{ 3, 0xD, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xD, 0x000800, 0x98B6, 0x98B6 },
	{ 5, 0xD, 0x00A0B6, 0xD1D8, 0xD1D8 },
	{ 3, 0x3, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x3, 0x000800, 0xEE5E, 0xEE5E },
	{ 5, 0x3, 0x00F65E, 0xFD08, 0xFD08 },
	{ 3, 0xA, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xA, 0x000800, 0x1B00, 0x1B00 },
	{ 5, 0xA, 0x002300, 0x5E58, 0x5E58 },
	{ 3, 0xA, 0x008158, 0x0800, 0x0800 },
	{ 4, 0xA, 0x008958, 0x99DC, 0x99DC },
	{ 5, 0xA, 0x012334, 0xFF9A, 0xFF9A },
	{ 3, 0xB, 0x000000, 0x0800, 0x0800 },
	{ 4, 0xB, 0x000800, 0x09F4, 0x09F4 },
	{ 5, 0xB, 0x0011F4, 0x4E3A, 0x4E3A },
	{ 0, 0x1, 0x02BA32, 0x0372, 0x0372 },
	{ 0, 0x2, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x1, 0x02BDA4, 0x08EA, 0x08EA },
	{ 0, 0x1, 0x02C68E, 0x1A46, 0x1A46 },
	{ 0, 0x2, 0x01CED2, 0x343E, 0x343E },
	{ 0, 0x2, 0x020310, 0x149E, 0x149E },
	{ 0, 0x2, 0x0217AE, 0x1866, 0x1866 },
	{ 0, 0x1, 0x02E0D4, 0x0266, 0x0266 },
	{ 0, 0x1, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x2, 0x023014, 0x01A8, 0x01A8 },
	{ 0, 0x1, 0x02E33A, 0x1FEC, 0x1FEC },
	{ 0, 0x2, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x2, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x2, 0x0231BC, 0x0E2A, 0x0E2A },
	{ 0, 0x2, 0x023FE6, 0x0366, 0x0366 },
	{ 0, 0x2, 0x02434C, 0x0078, 0x0078 },
	{ 0, 0x2, 0x0243C4, 0x1392, 0x1392 },
	{ 0, 0x2, 0x025756, 0x06E0, 0x06E0 },
	{ 0, 0x2, 0x025E36, 0x21AE, 0x21AE },
	{ 0, 0x1, 0x030326, 0x04FA, 0x04FA },
	{ 0, 0x1, 0x030820, 0x129E, 0x129E },
	{ 0, 0x1, 0x031ABE, 0x09B4, 0x09B4 },
	{ 0, 0x2, 0x027FE4, 0x04EC, 0x04EC },
	{ 2, 0x4, 0x000000, 0x2654, 0x7D00 },
	{ 2, 0x4, 0x002654, 0x1920, 0x7D00 },
	{ 2, 0x4, 0x003F74, 0x1A78, 0x7D00 },
	{ 2, 0x4, 0x0059EC, 0x1EC4, 0x7D00 },
	{ 2, 0x1, 0x032472, 0x045C, 0x7D00 },
	{ 2, 0x4, 0x0078B0, 0x2760, 0x7D00 },
	{ 2, 0x4, 0x00A010, 0x2B74, 0x7D00 },
	{ 0, 0x2, 0x0284D0, 0x03C0, 0x03C0 },
	{ 0, 0x2, 0x028890, 0x13E6, 0x13E6 },
	{ 0, 0x2, 0x029C76, 0x04DE, 0x04DE },
	{ 0, 0x2, 0x02A154, 0x05FA, 0x05FA },
	{ 0, 0x2, 0x02A74E, 0x025E, 0x025E },
	{ 0, 0x2, 0x02A9AC, 0x0642, 0x0642 },
	{ 0, 0x2, 0x02AFEE, 0x19D0, 0x19D0 },
	{ 0, 0x2, 0x02C9BE, 0x00E8, 0x00E8 },
	{ 0, 0x6, 0x000000, 0x1022, 0x1022 },
	{ 2, 0x1, 0x0328CE, 0x19FC, 0x7D00 },
	{ 0, 0x2, 0x02CAA6, 0x58AA, 0x58AA },
	{ 0, 0x6, 0x001022, 0x0990, 0x0990 },
	{ 0, 0x6, 0x0019B2, 0x2C42, 0x2C42 },
	{ 0, 0x6, 0x0045F4, 0x152C, 0x152C },
	{ 0, 0x6, 0x005B20, 0x05B4, 0x05B4 },
	{ 0, 0x6, 0x0060D4, 0x23B4, 0x23B4 },
	{ 0, 0x6, 0x008488, 0x1FA4, 0x1FA4 },
	{ 0, 0x6, 0x00A42C, 0x0D20, 0x0D20 },
	{ 0, 0x6, 0x00B14C, 0x0528, 0x0528 },
	{ 0, 0x6, 0x00B674, 0x1608, 0x1608 },
	{ 0, 0x6, 0x00CC7C, 0x01EA, 0x01EA },
	{ 0, 0x6, 0x00CE66, 0x07EA, 0x07EA },
	{ 0, 0x6, 0x00D650, 0x00E8, 0x00E8 },
	{ 0, 0x7, 0x000000, 0x3978, 0x3978 },
	{ 0, 0x7, 0x003978, 0x1178, 0x1178 },
	{ 0, 0x7, 0x004AF0, 0x14B0, 0x14B0 },
	{ 0, 0x7, 0x005FA0, 0x0AA4, 0x0AA4 },
	{ 0, 0x7, 0x006A44, 0x02DA, 0x02DA },
	{ 0, 0x7, 0x006D1E, 0x2674, 0x2674 },
	{ 0, 0x7, 0x009392, 0x12F0, 0x12F0 },
	{ 0, 0x7, 0x00A682, 0x5D58, 0x5D58 },
	{ 0, 0x7, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x2E68, 0x2E68 },
	{ 0, 0x8, 0x002E68, 0x51C6, 0x51C6 },
	{ 0, 0x8, 0x00802E, 0x13E6, 0x13E6 },
	{ 0, 0x8, 0x009414, 0x149E, 0x149E },
	{ 0, 0x8, 0x00A8B2, 0x58AA, 0x58AA },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x7, 0x0103DA, 0x0D90, 0x0D90 },
	{ 0, 0x7, 0x01116A, 0x09E4, 0x09E4 },
	{ 0, 0x7, 0x011B4E, 0x198A, 0x198A },
	{ 0, 0x7, 0x0134D8, 0x25D2, 0x25D2 },
	{ 0, 0x8, 0x01015C, 0x2430, 0x2430 },
	{ 0, 0x8, 0x01258C, 0x1316, 0x1316 },
	{ 0, 0x8, 0x0138A2, 0x0220, 0x0220 },
	{ 0, 0x8, 0x013AC2, 0x05EA, 0x05EA },
	{ 0, 0x8, 0x0140AC, 0x043C, 0x043C },
	{ 0, 0x8, 0x0144E8, 0x08EA, 0x08EA },
	{ 0, 0x8, 0x014DD2, 0x1478, 0x1478 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x01624A, 0x06CE, 0x06CE },
	{ 3, 0x9, 0x000000, 0x0800, 0x0800 },
	{ 4, 0x9, 0x000800, 0x0CC6, 0x0CC6 },
	{ 5, 0x9, 0x0014C6, 0x13B8, 0x13B8 },
	{ 0, 0x1, 0x0342CA, 0x189A, 0x189A },
	{ 0, 0x1, 0x035B64, 0x07D8, 0x07D8 },
	{ 0, 0x1, 0x03633C, 0x0462, 0x0462 },
	{ 0, 0x1, 0x03679E, 0x0FA8, 0x0FA8 },
	{ 0, 0xA, 0x0222CE, 0x672E, 0x672E },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 0, 0x8, 0x016918, 0x247C, 0x247C },
	{ 1, 0x2, 0x032350, 0x08C0, 0x08C0 },
	{ 1, 0xB, 0x00602E, 0x08C4, 0x3CC0 },
	{ 0, 0xA, 0x0289FC, 0x4F5A, 0x4F5A },
	{ 0, 0xA, 0x02D956, 0x4418, 0x4418 },
	{ 0, 0xA, 0x031D6E, 0x293C, 0x293C },
	{ 0, 0xA, 0x0346AA, 0x3FC8, 0x3FC8 },
	{ 0, 0x8, 0x000000, 0x0000, 0x0000 },
	{ 2, 0xB, 0x0068F2, 0x29C4, 0x7D00 },
	{ 2, 0xB, 0x0092B6, 0x2C00, 0x7D00 },
};

const uint8_t Mixer::_mt32SoundsTable[196] = {
	0x08, 0x94, 0x00, 0x00, 0x0a, 0x68, 0x40, 0x1f, 0x0b, 0x25, 0xe8, 0x03, 0x0c, 0x45, 0x01, 0x00,
	0x0d, 0x54, 0x10, 0x27, 0x0e, 0x68, 0x01, 0x00, 0x0f, 0x68, 0x64, 0x00, 0x10, 0x94, 0x00, 0x00,
	0x30, 0x63, 0x01, 0x00, 0x30, 0x64, 0x01, 0x00, 0x31, 0x6c, 0x08, 0x00, 0x32, 0x6c, 0x20, 0x03,
	0x33, 0x25, 0x01, 0x00, 0x35, 0x46, 0x80, 0x3e, 0x36, 0x54, 0x01, 0x00, 0x3a, 0x4f, 0xe0, 0x2e,
	0x3c, 0x51, 0x01, 0x00, 0x3e, 0x63, 0x08, 0x00, 0x3f, 0x45, 0x10, 0x27, 0x42, 0x46, 0x80, 0x3e,
	0x4a, 0x46, 0x58, 0x1b, 0x4e, 0x4f, 0x58, 0x1b, 0x4f, 0x4f, 0x70, 0x17, 0x51, 0x50, 0xe8, 0x03,
	0x52, 0x62, 0x01, 0x00, 0x52, 0x60, 0x01, 0x00, 0x55, 0x50, 0x01, 0x00, 0x56, 0x54, 0x01, 0x00,
	0x57, 0x55, 0x40, 0x06, 0x5b, 0x29, 0x01, 0x00, 0x5c, 0x46, 0x01, 0x00, 0x5d, 0x5a, 0x01, 0x00,
	0x5e, 0x24, 0x80, 0x3e, 0x5f, 0x45, 0x01, 0x00, 0x60, 0x50, 0xe8, 0x03, 0x62, 0x53, 0x40, 0x1f,
	0x63, 0x54, 0x10, 0x27, 0x67, 0x46, 0x80, 0x3e, 0x6a, 0x67, 0xe8, 0x03, 0x6b, 0x5a, 0x10, 0x27,
	0x6d, 0x6c, 0x08, 0x00, 0x75, 0x4e, 0x20, 0x03, 0x77, 0x4f, 0x10, 0x27, 0x88, 0x4e, 0x40, 0x1f,
	0x8b, 0x61, 0x01, 0x00, 0x8c, 0x63, 0x01, 0x00, 0x8d, 0x4d, 0x10, 0x27, 0x8e, 0x63, 0x80, 0x3e,
	0x00, 0x00, 0x00, 0x00
};
